/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

class ServletRequestWrappingHttpRequest
extends HttpRequest {
    private final HttpServletRequest req;

    ServletRequestWrappingHttpRequest(HttpServletRequest req) {
        super(HttpMethod.valueOf((String)req.getMethod()), req.getPathInfo() == null ? "/" : req.getPathInfo());
        this.req = req;
    }

    public Iterable<String> getHeaderNames() {
        return Collections.list(this.req.getHeaderNames());
    }

    public Iterable<String> getHeaders(String name) {
        return Collections.list(this.req.getHeaders(name));
    }

    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    public ServletRequestWrappingHttpRequest removeHeader(String name) {
        throw new UnsupportedOperationException("removeHeader");
    }

    public ServletRequestWrappingHttpRequest setHeader(String name, String value) {
        throw new UnsupportedOperationException("setHeader");
    }

    public ServletRequestWrappingHttpRequest addHeader(String name, String value) {
        throw new UnsupportedOperationException("addHeader");
    }

    public HttpRequest addQueryParameter(String name, String value) {
        throw new UnsupportedOperationException("addQueryParameter");
    }

    public Iterable<String> getQueryParameterNames() {
        return this.parseQueryString().keySet();
    }

    private Map<String, Collection<String>> parseQueryString() {
        String queryString = this.req.getQueryString();
        if (queryString == null || queryString.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMultimap.Builder allParams = ImmutableMultimap.builder();
        Iterable paramsAndValues = Splitter.on((String)"&").split((CharSequence)queryString);
        for (String paramAndValue : paramsAndValues) {
            String value;
            String key;
            int index = paramAndValue.indexOf("=");
            if (index == -1) {
                key = paramAndValue;
                value = "";
            } else {
                key = paramAndValue.substring(0, index);
                value = paramAndValue.length() >= index ? paramAndValue.substring(index + 1) : "";
            }
            try {
                allParams.put((Object)URLDecoder.decode(key, "UTF-8"), (Object)URLDecoder.decode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return allParams.build().asMap();
    }

    public Iterable<String> getQueryParameters(String name) {
        return this.parseQueryString().getOrDefault(name, (Collection<String>)ImmutableSet.of());
    }

    public Supplier<InputStream> getContent() {
        return Contents.memoize(() -> {
            try {
                return this.req.getInputStream();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public ServletRequestWrappingHttpRequest setContent(Supplier<InputStream> supplier) {
        throw new UnsupportedOperationException("setContent");
    }
}

