/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.json.JsonInput;

public class CapabilityCount {
    private final Map<Capabilities, Integer> counts;

    public CapabilityCount(Map<Capabilities, Integer> counts) {
        this.counts = ImmutableMap.copyOf(counts);
    }

    public Map<Capabilities, Integer> getCounts() {
        return this.counts;
    }

    private Object toJson() {
        return this.counts.entrySet().stream().map(entry -> ImmutableMap.of((Object)"capabilities", entry.getKey(), (Object)"count", entry.getValue())).collect(ImmutableList.toImmutableList());
    }

    private static CapabilityCount fromJson(JsonInput input) {
        HashMap<Capabilities, Integer> toReturn = new HashMap<Capabilities, Integer>();
        input.beginArray();
        while (input.hasNext()) {
            Capabilities caps = null;
            int count = 0;
            input.beginObject();
            block9: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "capabilities": {
                        caps = (Capabilities)input.read(Capabilities.class);
                        continue block9;
                    }
                    case "count": {
                        count = input.nextNumber().intValue();
                        continue block9;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            toReturn.put(caps, count);
        }
        input.endArray();
        return new CapabilityCount(toReturn);
    }
}

