/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.internal.Require;

public class MemoizedConfig
implements Config {
    private final Config delegate;
    private final Map<Key, Optional<Boolean>> seenBools = new ConcurrentHashMap<Key, Optional<Boolean>>();
    private final Map<Key, Object> seenClasses = new ConcurrentHashMap<Key, Object>();
    private final Map<Key, Optional<Integer>> seenInts = new ConcurrentHashMap<Key, Optional<Integer>>();
    private final Map<Key, Optional<String>> seenStrings = new ConcurrentHashMap<Key, Optional<String>>();
    private final Map<Key, Optional<List<String>>> seenOptions = new ConcurrentHashMap<Key, Optional<List<String>>>();

    public MemoizedConfig(Config delegate) {
        this.delegate = (Config)Require.nonNull((String)"Delegate config", (Object)delegate);
    }

    @Override
    public Set<String> getSectionNames() {
        return this.delegate.getSectionNames();
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull((String)"Section name", (Object)section);
        return this.delegate.getOptions(section);
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull((String)"Section name", (Object)section);
        Require.nonNull((String)"Option", (Object)option);
        return this.seenOptions.computeIfAbsent(new Key(section, option), ignored -> this.delegate.getAll(section, option));
    }

    @Override
    public Optional<String> get(String section, String option) {
        Require.nonNull((String)"Section name", (Object)section);
        Require.nonNull((String)"Option", (Object)option);
        return this.seenStrings.computeIfAbsent(new Key(section, option), ignored -> this.delegate.get(section, option));
    }

    @Override
    public Optional<Integer> getInt(String section, String option) {
        Require.nonNull((String)"Section name", (Object)section);
        Require.nonNull((String)"Option", (Object)option);
        return this.seenInts.computeIfAbsent(new Key(section, option), ignored -> this.delegate.getInt(section, option));
    }

    @Override
    public Optional<Boolean> getBool(String section, String option) {
        Require.nonNull((String)"Section name", (Object)section);
        Require.nonNull((String)"Option", (Object)option);
        return this.seenBools.computeIfAbsent(new Key(section, option), ignored -> this.delegate.getBool(section, option));
    }

    @Override
    public <X> X getClass(String section, String option, Class<X> typeOfX, String defaultClassName) {
        Require.nonNull((String)"Section name", (Object)section);
        Require.nonNull((String)"Option", (Object)option);
        Require.nonNull((String)"Type to load", typeOfX);
        Require.nonNull((String)"Default class name", (Object)defaultClassName);
        AtomicReference thrown = new AtomicReference();
        Object value = this.seenClasses.computeIfAbsent(new Key(section, option, typeOfX.toGenericString(), defaultClassName), ignored -> {
            try {
                return this.delegate.getClass(section, option, typeOfX, defaultClassName);
            }
            catch (Exception e) {
                thrown.set(e);
                return null;
            }
        });
        if (value != null) {
            return typeOfX.cast(value);
        }
        Exception exception = (Exception)thrown.get();
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new ConfigException(exception);
    }

    private static class Key {
        private final String[] segments;

        public Key(String ... segments) {
            this.segments = segments;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key that = (Key)o;
            return Arrays.equals(this.segments, that.segments);
        }

        public int hashCode() {
            return Arrays.hashCode(this.segments);
        }
    }
}

