/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;

public interface Config {
    public Set<String> getSectionNames();

    public Set<String> getOptions(String var1);

    public Optional<List<String>> getAll(String var1, String var2);

    default public Optional<String> get(String section, String option) {
        return this.getAll(section, option).map(items -> items.isEmpty() ? null : (String)items.get(0));
    }

    default public Optional<Integer> getInt(String section, String option) {
        return this.get(section, option).map(Integer::parseInt);
    }

    default public Optional<Boolean> getBool(String section, String option) {
        return this.get(section, option).map(Boolean::parseBoolean);
    }

    default public <X> X getClass(String section, String option, Class<X> typeOfClass, String defaultClazz) {
        String clazz = this.get(section, option).orElse(defaultClazz);
        Logger.getLogger(Config.class.getName()).fine(String.format("Creating %s as instance of %s", clazz, typeOfClass));
        try {
            Class<?> ClassClazz = Class.forName(clazz, true, Thread.currentThread().getContextClassLoader());
            Method create = ClassClazz.getMethod("create", Config.class);
            if (!Modifier.isStatic(create.getModifiers())) {
                throw new IllegalArgumentException(String.format("Class %s's `create(Config)` method must be static", clazz));
            }
            if (!typeOfClass.isAssignableFrom(create.getReturnType())) {
                throw new IllegalArgumentException(String.format("Class %s's `create(Config)` method must be static", clazz));
            }
            return typeOfClass.cast(create.invoke(null, this));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Class %s must have a static `create(Config)` method", clazz));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Unable to find class: " + clazz, e);
        }
    }
}

