/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class BrowserConfigurationOptions {
    public static final String PROXY_CONFIG = "proxy";
    public static final String PROFILE_NAME = "profile";
    public static final String SINGLE_WINDOW = "singleWindow";
    public static final String MULTI_WINDOW = "multiWindow";
    public static final String BROWSER_EXECUTABLE_PATH = "executablePath";
    public static final String TIMEOUT_IN_SECONDS = "timeoutInSeconds";
    public static final String BROWSER_MODE = "mode";
    public static final String COMMAND_LINE_FLAGS = "commandLineFlags";
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 1800;
    private Map<String, String> options = new HashMap<String, String>();

    public boolean hasOptions() {
        return !this.options.isEmpty();
    }

    public String serialize() {
        return this.options.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(";"));
    }

    public BrowserConfigurationOptions setProfile(String profile) {
        this.put(PROFILE_NAME, profile);
        return this;
    }

    protected String getProfile() {
        return this.options.get(PROFILE_NAME);
    }

    protected boolean isSingleWindow() {
        return this.isSet(SINGLE_WINDOW);
    }

    protected boolean isMultiWindow() {
        return this.isSet(MULTI_WINDOW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrowserConfigurationOptions setSingleWindow() {
        Map<String, String> map = this.options;
        synchronized (map) {
            this.options.put(SINGLE_WINDOW, "true");
            this.options.remove(MULTI_WINDOW);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrowserConfigurationOptions setMultiWindow() {
        Map<String, String> map = this.options;
        synchronized (map) {
            this.options.put(MULTI_WINDOW, "true");
            this.options.remove(SINGLE_WINDOW);
        }
        return this;
    }

    protected String getBrowserExecutablePath() {
        return this.options.get(BROWSER_EXECUTABLE_PATH);
    }

    public BrowserConfigurationOptions setBrowserExecutablePath(String executablePath) {
        this.put(BROWSER_EXECUTABLE_PATH, executablePath);
        return this;
    }

    public BrowserConfigurationOptions setTimeoutInSeconds(int timeout) {
        this.put(TIMEOUT_IN_SECONDS, String.valueOf(timeout));
        return this;
    }

    protected int getTimeoutInSeconds() {
        String value = this.options.get(TIMEOUT_IN_SECONDS);
        if (value == null) {
            return 1800;
        }
        return Integer.parseInt(value);
    }

    public BrowserConfigurationOptions setBrowserMode(String mode) {
        this.put(BROWSER_MODE, mode);
        return this;
    }

    protected String getBrowserMode() {
        return this.options.get(BROWSER_MODE);
    }

    public BrowserConfigurationOptions setCommandLineFlags(String cmdLineFlags) {
        this.put(COMMAND_LINE_FLAGS, cmdLineFlags);
        return this;
    }

    public String getCommandLineFlags() {
        return this.get(COMMAND_LINE_FLAGS);
    }

    protected boolean canUse(String value) {
        return value != null && !"".equals(value);
    }

    private void put(String key, String value) {
        if (this.canUse(value)) {
            this.options.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSet(String key) {
        boolean result = false;
        Map<String, String> map = this.options;
        synchronized (map) {
            result = null != this.options.get(key);
        }
        return result;
    }

    public String get(String key) {
        return this.options.get(key);
    }

    public BrowserConfigurationOptions set(String key, String value) {
        if (value != null) {
            this.options.put(key, value);
        }
        return this;
    }

    public String toString() {
        return this.serialize();
    }
}

