/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.session.remote;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.grid.session.remote.RemoteSession;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.server.jmx.JMXHelper;
import org.openqa.selenium.remote.server.jmx.ManagedService;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.remote.tracing.Tracer;

@ManagedService
public class ServicedSession
extends RemoteSession {
    private final DriverService service;

    public ServicedSession(DriverService service, Dialect downstream, Dialect upstream, HttpHandler codec, SessionId id, Map<String, Object> capabilities) {
        super(downstream, upstream, codec, id, capabilities);
        this.service = service;
        new JMXHelper().register(this);
    }

    public String toString() {
        return this.getId().toString() + " (" + this.service.getClass().getName() + ")";
    }

    @Override
    public void stop() {
        try {
            HttpRequest request = new HttpRequest(HttpMethod.DELETE, "/session/" + this.getId());
            this.execute(request);
        }
        catch (UncheckedIOException uncheckedIOException) {
            // empty catch block
        }
        this.service.stop();
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName(String.format("org.seleniumhq.server:type=Session,browser=\"%s\",id=%s", this.getCapabilities().get("browserName"), this.getId()));
    }

    public static class Factory
    extends RemoteSession.Factory<DriverService> {
        private final Tracer tracer;
        private final Predicate<Capabilities> key;
        private final Function<Capabilities, ? extends DriverService> createService;
        private final String serviceClassName;

        public Factory(Tracer tracer, Predicate<Capabilities> key, String serviceClassName) {
            this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
            this.key = (Predicate)Require.nonNull((String)"Accepted capabilities predicate", key);
            this.serviceClassName = (String)Require.nonNull((String)"Driver service class name", (Object)serviceClassName);
            try {
                Class<DriverService> driverClazz = Class.forName(serviceClassName).asSubclass(DriverService.class);
                Function<Capabilities, ? extends DriverService> factory = this.get(driverClazz, Capabilities.class);
                if (factory == null) {
                    factory = this.get(driverClazz, new Class[0]);
                }
                if (factory == null) {
                    throw new IllegalArgumentException("DriverService has no mechanism to create a default instance: " + serviceClassName);
                }
                this.createService = factory;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("DriverService class does not exist: " + serviceClassName);
            }
        }

        private Function<Capabilities, ? extends DriverService> get(Class<? extends DriverService> driverServiceClazz, Class ... args) {
            try {
                Method serviceMethod = driverServiceClazz.getDeclaredMethod("createDefaultService", args);
                serviceMethod.setAccessible(true);
                return caps -> {
                    try {
                        if (args.length > 0) {
                            return (DriverService)serviceMethod.invoke(null, caps);
                        }
                        return (DriverService)serviceMethod.invoke(null, new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new SessionNotCreatedException("Unable to create new service: " + driverServiceClazz.getSimpleName(), (Throwable)e);
                    }
                };
            }
            catch (ReflectiveOperationException e) {
                return null;
            }
        }

        @Override
        public boolean test(Capabilities capabilities) {
            return this.key.test(capabilities);
        }

        @Override
        public Optional<ActiveSession> apply(CreateSessionRequest sessionRequest) {
            Require.nonNull((String)"Session creation request", (Object)sessionRequest);
            DriverService service = this.createService.apply(sessionRequest.getCapabilities());
            try {
                service.start();
                PortProber.waitForPortUp((int)service.getUrl().getPort(), (int)30, (TimeUnit)TimeUnit.SECONDS);
                URL url = service.getUrl();
                return this.performHandshake(this.tracer, service, url, sessionRequest.getDownstreamDialects(), sessionRequest.getCapabilities());
            }
            catch (IOException | IllegalStateException | NullPointerException | InvalidArgumentException e) {
                RemoteSession.log.log(Level.INFO, e.getMessage(), e);
                service.stop();
                return Optional.empty();
            }
        }

        protected ServicedSession newActiveSession(DriverService service, Dialect downstream, Dialect upstream, HttpHandler codec, SessionId id, Map<String, Object> capabilities) {
            return new ServicedSession(service, downstream, upstream, codec, id, capabilities);
        }

        public String toString() {
            return this.getClass().getName() + " (provider: " + this.serviceClassName + ")";
        }
    }
}

