/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.remote.Dialect;

public class CreateSessionRequest {
    private final Set<Dialect> downstreamDialects;
    private final Capabilities capabilities;
    private final Map<String, Object> metadata;

    public CreateSessionRequest(Set<Dialect> downstreamDialects, Capabilities capabilities, Map<String, Object> metadata) {
        this.downstreamDialects = ImmutableSet.copyOf((Collection)((Collection)Require.nonNull((String)"Downstream dialects", downstreamDialects)));
        this.capabilities = ImmutableCapabilities.copyOf((Capabilities)((Capabilities)Require.nonNull((String)"Capabilities", (Object)capabilities)));
        this.metadata = ImmutableMap.copyOf((Map)((Map)Require.nonNull((String)"Metadata", metadata)));
    }

    public Set<Dialect> getDownstreamDialects() {
        return this.downstreamDialects;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    private static CreateSessionRequest fromJson(JsonInput input) {
        Set downstreamDialects = null;
        Capabilities capabilities = null;
        Map metadata = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "capabilities": {
                    capabilities = (Capabilities)input.read(Capabilities.class);
                    continue block10;
                }
                case "downstreamDialects": {
                    downstreamDialects = (Set)input.read(new TypeToken<Set<Dialect>>(){}.getType());
                    continue block10;
                }
                case "metadata": {
                    metadata = (Map)input.read(Json.MAP_TYPE);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CreateSessionRequest(downstreamDialects, capabilities, metadata);
    }

    public String toString() {
        return String.format("<CreateSessionRequest with %s>", this.capabilities);
    }
}

