/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.WebDriverBackedSelenium;
import com.thoughtworks.selenium.webdriven.WebDriverCommandProcessor;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.FormEncodedData;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.server.ActiveSessionFactory;
import org.openqa.selenium.remote.server.ActiveSessionListener;
import org.openqa.selenium.remote.server.ActiveSessions;
import org.openqa.selenium.remote.server.NewSessionPipeline;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.safari.SafariOptions;

public class WebDriverBackedSeleniumHandler
implements Routable {
    private static final Map<SessionId, CommandProcessor> PROCESSORS = new ConcurrentHashMap<SessionId, CommandProcessor>();
    public static final Logger LOG = Logger.getLogger(WebDriverBackedSelenium.class.getName());
    private NewSessionPipeline pipeline;
    private ActiveSessions sessions;
    private ActiveSessionListener listener;

    public WebDriverBackedSeleniumHandler(Tracer tracer, ActiveSessions sessions) {
        this.sessions = sessions == null ? new ActiveSessions(5L, TimeUnit.MINUTES) : sessions;
        this.listener = new ActiveSessionListener(){

            @Override
            public void onStop(ActiveSession session) {
                PROCESSORS.remove(session.getId());
            }
        };
        this.sessions.addListener(this.listener);
        this.pipeline = NewSessionPipeline.builder().add(new ActiveSessionFactory(tracer)).create();
    }

    public boolean matches(HttpRequest req) {
        return req.getMethod() == HttpMethod.POST && ("/selenium-server/driver/".equals(req.getUri()) || "/selenium-server/driver".equals(req.getUri()));
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Optional params = FormEncodedData.getData((HttpRequest)req);
        String cmd = this.getValue("cmd", params, req);
        SessionId sessionId = null;
        if (this.getValue("sessionId", params, req) != null) {
            sessionId = new SessionId(this.getValue("sessionId", params, req));
        }
        Object[] args = this.deserializeArgs(params, req);
        if (cmd == null) {
            return this.sendError(404, "Unable to find cmd query parameter");
        }
        StringBuilder printableArgs = new StringBuilder("[");
        Joiner.on((String)", ").appendTo(printableArgs, args);
        printableArgs.append("]");
        LOG.info(String.format("Command request: %s%s on session %s", cmd, printableArgs, sessionId));
        if ("getNewBrowserSession".equals(cmd)) {
            return this.startNewSession((String)args[0], (String)args[1], (String)(args.length == 4 ? args[3] : ""));
        }
        if ("testComplete".equals(cmd)) {
            CommandProcessor commandProcessor = PROCESSORS.get(sessionId);
            this.sessions.invalidate(sessionId);
            if (commandProcessor == null) {
                return this.sendError(404, "Unable to find command processor for " + sessionId);
            }
            return this.sendResponse(null);
        }
        CommandProcessor commandProcessor = PROCESSORS.get(sessionId);
        if (commandProcessor == null) {
            return this.sendError(404, "Unable to find command processor for " + sessionId);
        }
        try {
            String result = commandProcessor.doCommand(cmd, (String[])args);
            return this.sendResponse(result);
        }
        catch (SeleniumException e) {
            return this.sendError(200, e.getMessage());
        }
    }

    private HttpResponse startNewSession(String browserString, String baseUrl, String options) {
        ActiveSession session;
        SessionId sessionId = null;
        if (options.startsWith("webdriver.remote.sessionid")) {
            List split = Splitter.on((String)"=").omitEmptyStrings().trimResults().limit(2).splitToList((CharSequence)options);
            if (!"webdriver.remote.sessionid".equals(split.get(0))) {
                LOG.warning("Unable to find existing webdriver session. Wrong parameter name: " + options);
                return this.sendError(200, "Unable to find existing webdriver session. Wrong parameter name: " + options);
            }
            if (split.size() != 2) {
                LOG.warning("Attempted to find webdriver id, but none specified. Bailing");
                return this.sendError(200, "Unable to find existing webdriver session. No ID specified");
            }
            sessionId = new SessionId((String)split.get(1));
        }
        if (sessionId == null) {
            ImmutableCapabilities caps;
            switch (browserString) {
                case "*webdriver": {
                    caps = new ImmutableCapabilities();
                    break;
                }
                case "*chrome": 
                case "*firefox": 
                case "*firefoxproxy": 
                case "*firefoxchrome": 
                case "*pifirefox": {
                    caps = new FirefoxOptions();
                    break;
                }
                case "*iehta": 
                case "*iexplore": 
                case "*iexploreproxy": 
                case "*piiexplore": {
                    caps = new InternetExplorerOptions();
                    break;
                }
                case "*googlechrome": {
                    caps = new ChromeOptions();
                    break;
                }
                case "*MicrosoftEdge": {
                    caps = new EdgeOptions();
                    break;
                }
                case "*opera": 
                case "*operablink": {
                    caps = new OperaOptions();
                    break;
                }
                case "*safari": 
                case "*safariproxy": {
                    caps = new SafariOptions();
                    break;
                }
                default: {
                    return this.sendError(200, "Unable to match browser string: " + browserString);
                }
            }
            try (NewSessionPayload payload = NewSessionPayload.create((Capabilities)caps);){
                ActiveSession session2 = this.pipeline.createNewSession(payload);
                this.sessions.put(session2);
                sessionId = session2.getId();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to start session", e);
                return this.sendError(200, "Unable to start session. Cause can be found in logs. Message is: " + e.getMessage());
            }
        }
        if ((session = this.sessions.get(sessionId)) == null) {
            LOG.warning("Attempt to use non-existent session: " + sessionId);
            return this.sendError(200, "Attempt to use non-existent session: " + sessionId);
        }
        PROCESSORS.put(sessionId, new WebDriverCommandProcessor(baseUrl, session.getWrappedDriver()));
        return this.sendResponse(sessionId.toString());
    }

    private HttpResponse sendResponse(String result) {
        return (HttpResponse)((HttpResponse)new HttpResponse().setStatus(200).setHeader("", "")).setContent(Contents.utf8String((CharSequence)"OK".concat(result == null ? "" : "," + result)));
    }

    private HttpResponse sendError(int statusCode, String result) {
        return (HttpResponse)((HttpResponse)new HttpResponse().setStatus(statusCode).setHeader("", "")).setContent(Contents.utf8String((CharSequence)"ERROR".concat(result == null ? "" : ": " + result)));
    }

    private String[] deserializeArgs(Optional<Map<String, List<String>>> params, HttpRequest req) {
        String value;
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < 5 && (value = this.getValue(String.valueOf(i + 1), params, req)) != null; ++i) {
            args.add(value);
        }
        return args.toArray(new String[0]);
    }

    private String getValue(String key, Optional<Map<String, List<String>>> params, HttpRequest request) {
        return params.map(data -> {
            List values = data.getOrDefault(key, new ArrayList());
            if (values.isEmpty()) {
                return request.getQueryParameter(key);
            }
            return (String)values.get(0);
        }).orElseGet(() -> request.getQueryParameter(key));
    }
}

