/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.component;

import java.util.Objects;

@FunctionalInterface
public interface HealthCheck {
    public Result check();

    public static class Result {
        private final boolean isAlive;
        private final String message;
        private final String registrationSecret;

        public Result(boolean isAlive, String message) {
            this.isAlive = isAlive;
            this.message = Objects.requireNonNull(message, "Message must be set");
            this.registrationSecret = null;
        }

        public Result(boolean isAlive, String message, String registrationSecret) {
            this.isAlive = isAlive;
            this.message = Objects.requireNonNull(message, "Message must be set");
            this.registrationSecret = registrationSecret;
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

