/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.log;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ShortTermMemoryHandler
extends Handler {
    private final LogRecord[] lastRecords;
    private final int capacity;
    private final Formatter formatter;
    private int minimumLevel;
    private int currentIndex;

    public ShortTermMemoryHandler(int capacity, Level minimumLevel, Formatter formatter) {
        this.capacity = capacity;
        this.formatter = formatter;
        this.minimumLevel = minimumLevel.intValue();
        this.lastRecords = new LogRecord[capacity];
        this.currentIndex = 0;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (record.getLevel().intValue() < this.minimumLevel) {
            return;
        }
        this.lastRecords[this.currentIndex] = record;
        ++this.currentIndex;
        if (this.currentIndex >= this.capacity) {
            this.currentIndex = 0;
        }
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void close() throws SecurityException {
        for (int i = 0; i < this.capacity; ++i) {
            this.lastRecords[i] = null;
        }
    }

    public synchronized LogRecord[] records() {
        int i;
        ArrayList<LogRecord> validRecords = new ArrayList<LogRecord>(this.capacity);
        for (i = this.currentIndex; i < this.capacity; ++i) {
            if (null == this.lastRecords[i]) continue;
            validRecords.add(this.lastRecords[i]);
        }
        for (i = 0; i < this.currentIndex; ++i) {
            if (null == this.lastRecords[i]) continue;
            validRecords.add(this.lastRecords[i]);
        }
        return validRecords.toArray(new LogRecord[0]);
    }

    public synchronized String formattedRecords() {
        StringWriter writer = new StringWriter();
        for (LogRecord record : this.records()) {
            writer.append(this.formatter.format(record));
            writer.append("\n");
        }
        return writer.toString();
    }
}

