/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import java.io.UncheckedIOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.log.JavaUtilLog;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.server.AddWebDriverSpecHeaders;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.HttpHandlerServlet;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.grid.server.WrapExceptions;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.http.HttpHandler;

public class BaseServer<T extends BaseServer>
implements Server<T> {
    private static final Logger LOG = Logger.getLogger(BaseServer.class.getName());
    private static final int MAX_SHUTDOWN_RETRIES = 8;
    private final org.eclipse.jetty.server.Server server;
    private final ServletContextHandler servletContextHandler;
    private final URL url;
    private HttpHandler handler;

    public BaseServer(BaseServerOptions options) {
        int port = options.getPort() == 0 ? PortProber.findFreePort() : options.getPort();
        String host = options.getHostname().orElseGet(() -> {
            try {
                return new NetworkUtils().getNonLoopbackAddressOfThisMachine();
            }
            catch (WebDriverException ignored) {
                return "localhost";
            }
        });
        try {
            this.url = new URL("http", host, port, "");
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
        Log.setLog((org.eclipse.jetty.util.log.Logger)new JavaUtilLog());
        this.server = new org.eclipse.jetty.server.Server((ThreadPool)new QueuedThreadPool(options.getMaxServerThreads()));
        this.servletContextHandler = new ServletContextHandler(2);
        ConstraintSecurityHandler securityHandler = (ConstraintSecurityHandler)this.servletContextHandler.getSecurityHandler();
        Constraint disableTrace = new Constraint();
        disableTrace.setName("Disable TRACE");
        disableTrace.setAuthenticate(true);
        ConstraintMapping disableTraceMapping = new ConstraintMapping();
        disableTraceMapping.setConstraint(disableTrace);
        disableTraceMapping.setMethod("TRACE");
        disableTraceMapping.setPathSpec("/");
        securityHandler.addConstraintMapping(disableTraceMapping);
        Constraint enableOther = new Constraint();
        enableOther.setName("Enable everything but TRACE");
        ConstraintMapping enableOtherMapping = new ConstraintMapping();
        enableOtherMapping.setConstraint(enableOther);
        enableOtherMapping.setMethodOmissions(new String[]{"TRACE"});
        enableOtherMapping.setPathSpec("/");
        securityHandler.addConstraintMapping(enableOtherMapping);
        if (options.getAllowCORS()) {
            FilterHolder filterHolder = this.servletContextHandler.addFilter(CrossOriginFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
            filterHolder.setInitParameter("allowedOrigins", "*");
            LOG.warning("You have enabled CORS requests from any host. Be careful not to visit sites which could maliciously try to start Selenium sessions on your machine");
        }
        this.server.setHandler((Handler)this.servletContextHandler);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        ServerConnector http = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        options.getHostname().ifPresent(arg_0 -> ((ServerConnector)http).setHost(arg_0));
        http.setPort(this.getUrl().getPort());
        http.setIdleTimeout(500000L);
        this.server.setConnectors(new Connector[]{http});
    }

    @Override
    public void addServlet(Class<? extends Servlet> servlet, String pathSpec) {
        if (this.server.isRunning()) {
            throw new IllegalStateException("You may not add a servlet to a running server");
        }
        this.servletContextHandler.addServlet(Objects.requireNonNull(servlet), Objects.requireNonNull(pathSpec));
    }

    @Override
    public void addServlet(Servlet servlet, String pathSpec) {
        if (this.server.isRunning()) {
            throw new IllegalStateException("You may not add a servlet to a running server");
        }
        this.servletContextHandler.addServlet(new ServletHolder(Objects.requireNonNull(servlet)), Objects.requireNonNull(pathSpec));
    }

    @Override
    public T setHandler(HttpHandler handler) {
        if (this.server.isRunning()) {
            throw new IllegalStateException("You may not add a handler to a running server");
        }
        this.handler = Objects.requireNonNull(handler, "Handler to use must be set.");
        return (T)this;
    }

    @Override
    public boolean isStarted() {
        return this.server.isStarted();
    }

    @Override
    public T start() {
        try {
            if (this.handler == null) {
                throw new IllegalStateException("There must be at least one route specified");
            }
            this.addServlet((Servlet)new HttpHandlerServlet(this.handler.with(new WrapExceptions().andThen(new AddWebDriverSpecHeaders()))), "/*");
            this.server.start();
            PortProber.waitForPortUp((int)this.getUrl().getPort(), (int)10, (TimeUnit)TimeUnit.SECONDS);
            return (T)this;
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof BindException) {
                LOG.severe(String.format("Port %s is busy, please choose a free port and specify it using -port option", this.getUrl().getPort()));
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        Exception shutDownException = null;
        for (int numTries = 0; numTries <= 8; ++numTries) {
            try {
                this.server.stop();
                return;
            }
            catch (Exception ex) {
                shutDownException = ex;
                continue;
            }
        }
        throw new RuntimeException(shutDownException);
    }

    @Override
    public URL getUrl() {
        return this.url;
    }
}

