/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.SessionId;

public class NodeStatus {
    private final UUID nodeId;
    private final URI externalUri;
    private final int maxSessionCount;
    private final Map<Capabilities, Integer> stereotypes;
    private final Set<Active> snapshot;

    public NodeStatus(UUID nodeId, URI externalUri, int maxSessionCount, Map<Capabilities, Integer> stereotypes, Collection<Active> snapshot) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.externalUri = Objects.requireNonNull(externalUri);
        Preconditions.checkArgument((maxSessionCount > 0 ? 1 : 0) != 0, (Object)"Max session count must be greater than 0.");
        this.maxSessionCount = maxSessionCount;
        this.stereotypes = ImmutableMap.copyOf(Objects.requireNonNull(stereotypes));
        this.snapshot = ImmutableSet.copyOf(Objects.requireNonNull(snapshot));
    }

    public boolean hasCapacity() {
        return !this.stereotypes.isEmpty();
    }

    public boolean hasCapacity(Capabilities caps) {
        return this.stereotypes.getOrDefault(caps, 0) > 0;
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public URI getUri() {
        return this.externalUri;
    }

    public int getMaxSessionCount() {
        return this.maxSessionCount;
    }

    public Map<Capabilities, Integer> getStereotypes() {
        return this.stereotypes;
    }

    public Set<Active> getCurrentSessions() {
        return this.snapshot;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeStatus)) {
            return false;
        }
        NodeStatus that = (NodeStatus)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.externalUri, that.externalUri) && this.maxSessionCount == that.maxSessionCount && Objects.equals(this.stereotypes, that.stereotypes) && Objects.equals(this.snapshot, that.snapshot);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.externalUri, this.maxSessionCount, this.stereotypes, this.snapshot);
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of((Object)"id", (Object)this.nodeId, (Object)"uri", (Object)this.externalUri, (Object)"maxSessions", (Object)this.maxSessionCount, (Object)"stereotypes", this.asCapacity(this.stereotypes), (Object)"sessions", this.snapshot);
    }

    private List<Map<String, Object>> asCapacity(Map<Capabilities, Integer> toConvert) {
        ImmutableList.Builder toReturn = ImmutableList.builder();
        toConvert.forEach((caps, count) -> toReturn.add((Object)ImmutableMap.of((Object)"capabilities", (Object)caps, (Object)"count", (Object)count)));
        return toReturn.build();
    }

    public static NodeStatus fromJson(Map<String, Object> raw) {
        List sessions = (List)((Collection)raw.get("sessions")).stream().map(item -> {
            Map converted = (Map)item;
            return converted;
        }).map(x$0 -> Active.fromJson(x$0)).collect(ImmutableList.toImmutableList());
        try {
            return new NodeStatus(UUID.fromString((String)raw.get("id")), new URI((String)raw.get("uri")), ((Number)raw.get("maxSessions")).intValue(), NodeStatus.readCapacityNamed(raw, "stereotypes"), sessions);
        }
        catch (URISyntaxException e) {
            throw new JsonException((Throwable)e);
        }
    }

    private static Map<Capabilities, Integer> readCapacityNamed(Map<String, Object> raw, String name) {
        ImmutableMap.Builder capacity = ImmutableMap.builder();
        ((Collection)raw.get(name)).forEach(obj -> {
            Map cap = (Map)obj;
            capacity.put((Object)new ImmutableCapabilities((Map)cap.get("capabilities")), (Object)((Number)cap.get("count")).intValue());
        });
        return capacity.build();
    }

    public static class Active {
        private final Capabilities stereotype;
        private final SessionId id;
        private final Capabilities currentCapabilities;

        public Active(Capabilities stereotype, SessionId id, Capabilities currentCapabilities) {
            this.stereotype = ImmutableCapabilities.copyOf((Capabilities)Objects.requireNonNull(stereotype));
            this.id = Objects.requireNonNull(id);
            this.currentCapabilities = ImmutableCapabilities.copyOf((Capabilities)Objects.requireNonNull(currentCapabilities));
        }

        public Capabilities getStereotype() {
            return this.stereotype;
        }

        public SessionId getSessionId() {
            return this.id;
        }

        public Capabilities getCurrentCapabilities() {
            return this.currentCapabilities;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Active)) {
                return false;
            }
            Active that = (Active)o;
            return Objects.equals(this.getStereotype(), that.getStereotype()) && Objects.equals(this.id, that.id) && Objects.equals(this.getCurrentCapabilities(), that.getCurrentCapabilities());
        }

        public int hashCode() {
            return Objects.hash(this.getStereotype(), this.id, this.getCurrentCapabilities());
        }

        private Map<String, Object> toJson() {
            return ImmutableMap.of((Object)"sessionId", (Object)this.getSessionId(), (Object)"stereotype", (Object)this.getStereotype(), (Object)"currentCapabilities", (Object)this.getCurrentCapabilities());
        }

        private static Active fromJson(Map<String, Object> raw) {
            SessionId id = new SessionId((String)raw.get("sessionId"));
            ImmutableCapabilities stereotype = new ImmutableCapabilities((Map)raw.get("stereotype"));
            ImmutableCapabilities current = new ImmutableCapabilities((Map)raw.get("currentCapabilities"));
            return new Active((Capabilities)stereotype, id, (Capabilities)current);
        }
    }
}

