/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.codec.jwp.JsonHttpCommandCodec;
import org.openqa.selenium.remote.codec.jwp.JsonHttpResponseCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpCommandCodec;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.RequiresAllSessions;
import org.openqa.selenium.remote.server.RequiresSession;
import org.openqa.selenium.remote.server.handler.AcceptAlert;
import org.openqa.selenium.remote.server.handler.AddCookie;
import org.openqa.selenium.remote.server.handler.CaptureScreenshot;
import org.openqa.selenium.remote.server.handler.ChangeUrl;
import org.openqa.selenium.remote.server.handler.ClearElement;
import org.openqa.selenium.remote.server.handler.ClickElement;
import org.openqa.selenium.remote.server.handler.CloseWindow;
import org.openqa.selenium.remote.server.handler.ConfigureTimeout;
import org.openqa.selenium.remote.server.handler.DeleteCookie;
import org.openqa.selenium.remote.server.handler.DeleteNamedCookie;
import org.openqa.selenium.remote.server.handler.DeleteSession;
import org.openqa.selenium.remote.server.handler.DismissAlert;
import org.openqa.selenium.remote.server.handler.ElementEquality;
import org.openqa.selenium.remote.server.handler.ExecuteAsyncScript;
import org.openqa.selenium.remote.server.handler.ExecuteScript;
import org.openqa.selenium.remote.server.handler.FindActiveElement;
import org.openqa.selenium.remote.server.handler.FindChildElement;
import org.openqa.selenium.remote.server.handler.FindChildElements;
import org.openqa.selenium.remote.server.handler.FindElement;
import org.openqa.selenium.remote.server.handler.FindElements;
import org.openqa.selenium.remote.server.handler.FullscreenWindow;
import org.openqa.selenium.remote.server.handler.GetAlertText;
import org.openqa.selenium.remote.server.handler.GetAllCookies;
import org.openqa.selenium.remote.server.handler.GetAllSessions;
import org.openqa.selenium.remote.server.handler.GetAllWindowHandles;
import org.openqa.selenium.remote.server.handler.GetAvailableLogTypesHandler;
import org.openqa.selenium.remote.server.handler.GetCookie;
import org.openqa.selenium.remote.server.handler.GetCssProperty;
import org.openqa.selenium.remote.server.handler.GetCurrentUrl;
import org.openqa.selenium.remote.server.handler.GetCurrentWindowHandle;
import org.openqa.selenium.remote.server.handler.GetElementAttribute;
import org.openqa.selenium.remote.server.handler.GetElementDisplayed;
import org.openqa.selenium.remote.server.handler.GetElementEnabled;
import org.openqa.selenium.remote.server.handler.GetElementLocation;
import org.openqa.selenium.remote.server.handler.GetElementLocationInView;
import org.openqa.selenium.remote.server.handler.GetElementRect;
import org.openqa.selenium.remote.server.handler.GetElementSelected;
import org.openqa.selenium.remote.server.handler.GetElementSize;
import org.openqa.selenium.remote.server.handler.GetElementText;
import org.openqa.selenium.remote.server.handler.GetLogHandler;
import org.openqa.selenium.remote.server.handler.GetPageSource;
import org.openqa.selenium.remote.server.handler.GetScreenOrientation;
import org.openqa.selenium.remote.server.handler.GetSessionCapabilities;
import org.openqa.selenium.remote.server.handler.GetSessionLogsHandler;
import org.openqa.selenium.remote.server.handler.GetTagName;
import org.openqa.selenium.remote.server.handler.GetTitle;
import org.openqa.selenium.remote.server.handler.GetWindowPosition;
import org.openqa.selenium.remote.server.handler.GetWindowSize;
import org.openqa.selenium.remote.server.handler.GoBack;
import org.openqa.selenium.remote.server.handler.GoForward;
import org.openqa.selenium.remote.server.handler.ImeActivateEngine;
import org.openqa.selenium.remote.server.handler.ImeDeactivate;
import org.openqa.selenium.remote.server.handler.ImeGetActiveEngine;
import org.openqa.selenium.remote.server.handler.ImeGetAvailableEngines;
import org.openqa.selenium.remote.server.handler.ImeIsActivated;
import org.openqa.selenium.remote.server.handler.ImplicitlyWait;
import org.openqa.selenium.remote.server.handler.MaximizeWindow;
import org.openqa.selenium.remote.server.handler.RefreshPage;
import org.openqa.selenium.remote.server.handler.Rotate;
import org.openqa.selenium.remote.server.handler.SendKeys;
import org.openqa.selenium.remote.server.handler.SetAlertText;
import org.openqa.selenium.remote.server.handler.SetScriptTimeout;
import org.openqa.selenium.remote.server.handler.SetWindowPosition;
import org.openqa.selenium.remote.server.handler.SetWindowSize;
import org.openqa.selenium.remote.server.handler.Status;
import org.openqa.selenium.remote.server.handler.SubmitElement;
import org.openqa.selenium.remote.server.handler.SwitchToFrame;
import org.openqa.selenium.remote.server.handler.SwitchToParentFrame;
import org.openqa.selenium.remote.server.handler.SwitchToWindow;
import org.openqa.selenium.remote.server.handler.UploadFile;
import org.openqa.selenium.remote.server.handler.W3CActions;
import org.openqa.selenium.remote.server.handler.html5.ClearLocalStorage;
import org.openqa.selenium.remote.server.handler.html5.ClearSessionStorage;
import org.openqa.selenium.remote.server.handler.html5.GetAppCacheStatus;
import org.openqa.selenium.remote.server.handler.html5.GetLocalStorageItem;
import org.openqa.selenium.remote.server.handler.html5.GetLocalStorageKeys;
import org.openqa.selenium.remote.server.handler.html5.GetLocalStorageSize;
import org.openqa.selenium.remote.server.handler.html5.GetLocationContext;
import org.openqa.selenium.remote.server.handler.html5.GetSessionStorageItem;
import org.openqa.selenium.remote.server.handler.html5.GetSessionStorageKeys;
import org.openqa.selenium.remote.server.handler.html5.GetSessionStorageSize;
import org.openqa.selenium.remote.server.handler.html5.RemoveLocalStorageItem;
import org.openqa.selenium.remote.server.handler.html5.RemoveSessionStorageItem;
import org.openqa.selenium.remote.server.handler.html5.SetLocalStorageItem;
import org.openqa.selenium.remote.server.handler.html5.SetLocationContext;
import org.openqa.selenium.remote.server.handler.html5.SetSessionStorageItem;
import org.openqa.selenium.remote.server.handler.interactions.ClickInSession;
import org.openqa.selenium.remote.server.handler.interactions.DoubleClickInSession;
import org.openqa.selenium.remote.server.handler.interactions.MouseDown;
import org.openqa.selenium.remote.server.handler.interactions.MouseMoveToLocation;
import org.openqa.selenium.remote.server.handler.interactions.MouseUp;
import org.openqa.selenium.remote.server.handler.interactions.SendKeyToActiveElement;
import org.openqa.selenium.remote.server.handler.interactions.touch.DoubleTapOnElement;
import org.openqa.selenium.remote.server.handler.interactions.touch.Down;
import org.openqa.selenium.remote.server.handler.interactions.touch.Flick;
import org.openqa.selenium.remote.server.handler.interactions.touch.LongPressOnElement;
import org.openqa.selenium.remote.server.handler.interactions.touch.Move;
import org.openqa.selenium.remote.server.handler.interactions.touch.Scroll;
import org.openqa.selenium.remote.server.handler.interactions.touch.SingleTapOnElement;
import org.openqa.selenium.remote.server.handler.interactions.touch.Up;
import org.openqa.selenium.remote.server.handler.mobile.GetNetworkConnection;
import org.openqa.selenium.remote.server.handler.mobile.SetNetworkConnection;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.log.PerSessionLogHandler;
import org.openqa.selenium.remote.server.rest.RestishHandler;
import org.openqa.selenium.remote.server.rest.ResultConfig;

public class JsonHttpCommandHandler {
    private final DriverSessions sessions;
    private final Logger log;
    private final Set<CommandCodec<HttpRequest>> commandCodecs;
    private final ResponseCodec<HttpResponse> responseCodec;
    private final Map<String, ResultConfig> configs = new LinkedHashMap<String, ResultConfig>();
    private final ErrorCodes errorCodes = new ErrorCodes();

    public JsonHttpCommandHandler(DriverSessions sessions, Logger log) {
        this.sessions = sessions;
        this.log = log;
        this.commandCodecs = new LinkedHashSet<CommandCodec<HttpRequest>>();
        this.commandCodecs.add((CommandCodec<HttpRequest>)new JsonHttpCommandCodec());
        this.commandCodecs.add((CommandCodec<HttpRequest>)new W3CHttpCommandCodec());
        this.responseCodec = new JsonHttpResponseCodec();
        this.setUpMappings();
    }

    public void addNewMapping(String commandName, Supplier<RestishHandler<?>> factory) {
        ResultConfig config = new ResultConfig(commandName, factory, this.sessions, this.log);
        this.configs.put(commandName, config);
    }

    public void addNewMapping(String commandName, RequiresAllSessions factory) {
        ResultConfig config = new ResultConfig(commandName, factory, this.sessions, this.log);
        this.configs.put(commandName, config);
    }

    public void addNewMapping(String commandName, RequiresSession factory) {
        ResultConfig config = new ResultConfig(commandName, factory, this.sessions, this.log);
        this.configs.put(commandName, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpRequest request, HttpResponse resp) {
        Response response;
        block7: {
            LoggingManager.perSessionLogHandler().clearThreadTempLogs();
            this.log.fine(String.format("Handling: %s %s", request.getMethod(), request.getUri()));
            Command command = null;
            try {
                command = this.decode(request);
                ResultConfig config = this.configs.get(command.getName());
                if (config == null) {
                    throw new UnsupportedCommandException();
                }
                response = config.handle(command);
                this.log.fine(String.format("Finished: %s %s", request.getMethod(), request.getUri()));
            }
            catch (Exception e) {
                this.log.fine(String.format("Error on: %s %s", request.getMethod(), request.getUri()));
                response = new Response();
                response.setStatus(Integer.valueOf(this.errorCodes.toStatusCode((Throwable)e)));
                response.setState(this.errorCodes.toState(response.getStatus()));
                response.setValue((Object)e);
                if (command == null || command.getSessionId() == null) break block7;
                response.setSessionId(command.getSessionId().toString());
            }
        }
        PerSessionLogHandler handler = LoggingManager.perSessionLogHandler();
        if (response.getSessionId() != null) {
            handler.attachToCurrentThread(new SessionId(response.getSessionId()));
        }
        try {
            this.responseCodec.encode(() -> resp, response);
        }
        finally {
            handler.detachFromCurrentThread();
        }
    }

    private Command decode(HttpRequest request) {
        UnsupportedCommandException lastException = null;
        for (CommandCodec<HttpRequest> codec : this.commandCodecs) {
            try {
                return codec.decode((Object)request);
            }
            catch (UnsupportedCommandException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new UnsupportedOperationException("Cannot find command for: " + request.getUri());
    }

    private void setUpMappings() {
        this.addNewMapping("status", Status::new);
        this.addNewMapping("getAllSessions", GetAllSessions::new);
        this.addNewMapping("getCapabilities", GetSessionCapabilities::new);
        this.addNewMapping("quit", DeleteSession::new);
        this.addNewMapping("getCurrentWindowHandle", GetCurrentWindowHandle::new);
        this.addNewMapping("getWindowHandles", GetAllWindowHandles::new);
        this.addNewMapping("dismissAlert", DismissAlert::new);
        this.addNewMapping("acceptAlert", AcceptAlert::new);
        this.addNewMapping("getAlertText", GetAlertText::new);
        this.addNewMapping("setAlertValue", SetAlertText::new);
        this.addNewMapping("get", ChangeUrl::new);
        this.addNewMapping("getCurrentUrl", GetCurrentUrl::new);
        this.addNewMapping("goForward", GoForward::new);
        this.addNewMapping("goBack", GoBack::new);
        this.addNewMapping("refresh", RefreshPage::new);
        this.addNewMapping("executeScript", ExecuteScript::new);
        this.addNewMapping("executeAsyncScript", ExecuteAsyncScript::new);
        this.addNewMapping("getPageSource", GetPageSource::new);
        this.addNewMapping("screenshot", CaptureScreenshot::new);
        this.addNewMapping("getTitle", GetTitle::new);
        this.addNewMapping("findElement", FindElement::new);
        this.addNewMapping("findElements", FindElements::new);
        this.addNewMapping("getActiveElement", FindActiveElement::new);
        this.addNewMapping("findChildElement", FindChildElement::new);
        this.addNewMapping("findChildElements", FindChildElements::new);
        this.addNewMapping("clickElement", ClickElement::new);
        this.addNewMapping("getElementText", GetElementText::new);
        this.addNewMapping("submitElement", SubmitElement::new);
        this.addNewMapping("uploadFile", UploadFile::new);
        this.addNewMapping("sendKeysToElement", SendKeys::new);
        this.addNewMapping("getElementTagName", GetTagName::new);
        this.addNewMapping("clearElement", ClearElement::new);
        this.addNewMapping("isElementSelected", GetElementSelected::new);
        this.addNewMapping("isElementEnabled", GetElementEnabled::new);
        this.addNewMapping("isElementDisplayed", GetElementDisplayed::new);
        this.addNewMapping("getElementLocation", GetElementLocation::new);
        this.addNewMapping("getElementLocationOnceScrolledIntoView", GetElementLocationInView::new);
        this.addNewMapping("getElementSize", GetElementSize::new);
        this.addNewMapping("getElementValueOfCssProperty", GetCssProperty::new);
        this.addNewMapping("getElementRect", GetElementRect::new);
        this.addNewMapping("getElementAttribute", GetElementAttribute::new);
        this.addNewMapping("elementEquals", ElementEquality::new);
        this.addNewMapping("getCookies", GetAllCookies::new);
        this.addNewMapping("getCookie", GetCookie::new);
        this.addNewMapping("addCookie", AddCookie::new);
        this.addNewMapping("deleteAllCookies", DeleteCookie::new);
        this.addNewMapping("deleteCookie", DeleteNamedCookie::new);
        this.addNewMapping("switchToFrame", SwitchToFrame::new);
        this.addNewMapping("switchToParentFrame", SwitchToParentFrame::new);
        this.addNewMapping("switchToWindow", SwitchToWindow::new);
        this.addNewMapping("close", CloseWindow::new);
        this.addNewMapping("getCurrentWindowSize", GetWindowSize::new);
        this.addNewMapping("setCurrentWindowSize", SetWindowSize::new);
        this.addNewMapping("getWindowPosition", GetWindowPosition::new);
        this.addNewMapping("setWindowPosition", SetWindowPosition::new);
        this.addNewMapping("maximizeCurrentWindow", MaximizeWindow::new);
        this.addNewMapping("fullscreenCurrentWindow", FullscreenWindow::new);
        this.addNewMapping("setTimeout", ConfigureTimeout::new);
        this.addNewMapping("implicitlyWait", ImplicitlyWait::new);
        this.addNewMapping("setScriptTimeout", SetScriptTimeout::new);
        this.addNewMapping("getLocation", GetLocationContext::new);
        this.addNewMapping("setLocation", SetLocationContext::new);
        this.addNewMapping("getStatus", GetAppCacheStatus::new);
        this.addNewMapping("getLocalStorageItem", GetLocalStorageItem::new);
        this.addNewMapping("removeLocalStorageItem", RemoveLocalStorageItem::new);
        this.addNewMapping("getLocalStorageKeys", GetLocalStorageKeys::new);
        this.addNewMapping("setLocalStorageItem", SetLocalStorageItem::new);
        this.addNewMapping("clearLocalStorage", ClearLocalStorage::new);
        this.addNewMapping("getLocalStorageSize", GetLocalStorageSize::new);
        this.addNewMapping("getSessionStorageItem", GetSessionStorageItem::new);
        this.addNewMapping("removeSessionStorageItem", RemoveSessionStorageItem::new);
        this.addNewMapping("getSessionStorageKey", GetSessionStorageKeys::new);
        this.addNewMapping("setSessionStorageItem", SetSessionStorageItem::new);
        this.addNewMapping("clearSessionStorage", ClearSessionStorage::new);
        this.addNewMapping("getSessionStorageSize", GetSessionStorageSize::new);
        this.addNewMapping("getScreenOrientation", GetScreenOrientation::new);
        this.addNewMapping("setScreenOrientation", Rotate::new);
        this.addNewMapping("mouseMoveTo", MouseMoveToLocation::new);
        this.addNewMapping("mouseClick", ClickInSession::new);
        this.addNewMapping("mouseDoubleClick", DoubleClickInSession::new);
        this.addNewMapping("mouseButtonDown", MouseDown::new);
        this.addNewMapping("mouseButtonUp", MouseUp::new);
        this.addNewMapping("sendKeysToActiveElement", SendKeyToActiveElement::new);
        this.addNewMapping("imeGetAvailableEngines", ImeGetAvailableEngines::new);
        this.addNewMapping("imeGetActiveEngine", ImeGetActiveEngine::new);
        this.addNewMapping("imeIsActivated", ImeIsActivated::new);
        this.addNewMapping("imeDeactivate", ImeDeactivate::new);
        this.addNewMapping("imeActivateEngine", ImeActivateEngine::new);
        this.addNewMapping("actions", W3CActions::new);
        this.addNewMapping("touchSingleTap", SingleTapOnElement::new);
        this.addNewMapping("touchDown", Down::new);
        this.addNewMapping("touchUp", Up::new);
        this.addNewMapping("touchMove", Move::new);
        this.addNewMapping("touchScroll", Scroll::new);
        this.addNewMapping("touchDoubleTap", DoubleTapOnElement::new);
        this.addNewMapping("touchLongPress", LongPressOnElement::new);
        this.addNewMapping("touchFlick", Flick::new);
        this.addNewMapping("getAvailableLogTypes", GetAvailableLogTypesHandler::new);
        this.addNewMapping("getLog", GetLogHandler::new);
        this.addNewMapping("getSessionLogs", GetSessionLogsHandler::new);
        this.addNewMapping("getNetworkConnection", GetNetworkConnection::new);
        this.addNewMapping("setNetworkConnection", SetNetworkConnection::new);
        this.addNewMapping("getWindowSize", GetWindowSize::new);
        this.addNewMapping("setWindowSize", SetWindowSize::new);
        this.addNewMapping("maximizeWindow", MaximizeWindow::new);
    }
}

