/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.remote.http.HttpRequest;

public abstract class Route<T extends Route> {
    private final List<Function<CommandHandler, CommandHandler>> decorators = new ArrayList<Function<CommandHandler, CommandHandler>>();
    private Supplier<CommandHandler> fallback;

    protected Route() {
    }

    protected abstract void validate();

    protected abstract CommandHandler newHandler(HttpRequest var1);

    public T decorateWith(Function<CommandHandler, CommandHandler> decorator) {
        this.decorators.add(decorator);
        return (T)this;
    }

    public T fallbackTo(Supplier<CommandHandler> fallbackSupplier) {
        Objects.requireNonNull(fallbackSupplier);
        this.fallback = fallbackSupplier;
        return (T)this;
    }

    public T fallbackTo(CommandHandler fallback) {
        Objects.requireNonNull(fallback);
        this.fallback = () -> fallback;
        return (T)this;
    }

    public Routes build() {
        this.validate();
        Function<HttpRequest, CommandHandler> func = req -> {
            CommandHandler handler = this.newHandler((HttpRequest)req);
            if (handler == null) {
                return this.getFallback();
            }
            for (Function<CommandHandler, CommandHandler> decorator : this.decorators) {
                handler = decorator.apply(handler);
            }
            return handler;
        };
        return new Routes(func);
    }

    protected CommandHandler getFallback() {
        return this.fallback == null ? null : this.fallback.get();
    }
}

