/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.rest;

import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.DeleteSession;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.log.PerSessionLogHandler;
import org.openqa.selenium.remote.server.rest.PropertyMunger;
import org.openqa.selenium.remote.server.rest.Responses;
import org.openqa.selenium.remote.server.rest.RestishHandler;

public class ResultConfig {
    private final String commandName;
    private final HandlerFactory handlerFactory;
    private final DriverSessions sessions;
    private final Logger log;

    public ResultConfig(String commandName, Class<? extends RestishHandler<?>> handlerClazz, DriverSessions sessions, Logger log) {
        if (commandName == null || handlerClazz == null) {
            throw new IllegalArgumentException("You must specify the handler and the command name");
        }
        this.commandName = commandName;
        this.log = log;
        this.sessions = sessions;
        this.handlerFactory = this.getHandlerFactory(handlerClazz);
    }

    protected RestishHandler<?> populate(RestishHandler<?> handler, Command command) {
        for (Map.Entry entry : command.getParameters().entrySet()) {
            try {
                PropertyMunger.set((String)entry.getKey(), handler, entry.getValue());
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        return handler;
    }

    public Response handle(Command command) throws Exception {
        Response response = new Response();
        SessionId sessionId = command.getSessionId();
        if (sessionId != null) {
            response.setSessionId(sessionId.toString());
        }
        this.throwUpIfSessionTerminated(sessionId);
        RestishHandler<?> handler = this.handlerFactory.createHandler(sessionId);
        this.populate(handler, command);
        try {
            Map parameters;
            if (handler instanceof JsonParametersAware && !(parameters = command.getParameters()).isEmpty()) {
                ((JsonParametersAware)((Object)handler)).setJsonParameters(parameters);
            }
            this.throwUpIfSessionTerminated(sessionId);
            if ("status".equals(command.getName())) {
                this.log.fine(String.format("Executing: %s)", handler));
            } else {
                this.log.info(String.format("Executing: %s)", handler));
            }
            Object value = handler.handle();
            if (value instanceof Response) {
                response = (Response)value;
            } else {
                response.setValue(value);
                response.setState("success");
                response.setStatus(Integer.valueOf(0));
            }
            if ("status".equals(command.getName())) {
                this.log.fine("Done: " + handler);
            } else {
                this.log.info("Done: " + handler);
            }
        }
        catch (UnreachableBrowserException e) {
            this.throwUpIfSessionTerminated(sessionId);
            return Responses.failure(sessionId, e);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Exception thrown", e);
            Throwable toUse = this.getRootExceptionCause(e);
            this.log.warning("Exception: " + toUse.getMessage());
            Optional<String> screenshot = Optional.empty();
            if (handler instanceof WebDriverHandler) {
                screenshot = Optional.ofNullable(((WebDriverHandler)handler).getScreenshot());
            }
            response = Responses.failure(sessionId, toUse, screenshot);
        }
        catch (Error e) {
            this.log.info("Error: " + e.getMessage());
            response = Responses.failure(sessionId, e);
        }
        if (handler instanceof DeleteSession) {
            PerSessionLogHandler logHandler = LoggingManager.perSessionLogHandler();
            logHandler.transferThreadTempLogsToSessionLogs(sessionId);
            logHandler.removeSessionLogs(sessionId);
        }
        return response;
    }

    private void throwUpIfSessionTerminated(SessionId sessId) throws NoSuchSessionException {
        boolean isTerminated;
        if (sessId == null) {
            return;
        }
        Session session = this.sessions.get(sessId);
        boolean bl = isTerminated = session == null;
        if (isTerminated) {
            throw new NoSuchSessionException();
        }
    }

    public Throwable getRootExceptionCause(Throwable originalException) {
        Throwable toReturn = originalException;
        if (originalException instanceof UndeclaredThrowableException) {
            toReturn = originalException.getCause().getCause();
        }
        ArrayList chain = Lists.newArrayListWithExpectedSize((int)10);
        for (Throwable current = toReturn; current != null && chain.size() < 10; current = current.getCause()) {
            chain.add(current);
        }
        if (chain.isEmpty()) {
            return null;
        }
        ErrorCodes ec = new ErrorCodes();
        Iterator reversedChain = Lists.reverse((List)chain).iterator();
        Throwable rootCause = (Throwable)reversedChain.next();
        if (!reversedChain.hasNext() || ec.isMappableError(rootCause)) {
            return rootCause;
        }
        Throwable nextCause = (Throwable)reversedChain.next();
        return ec.isMappableError(nextCause) ? nextCause : rootCause;
    }

    private HandlerFactory getHandlerFactory(Class<? extends RestishHandler<?>> handlerClazz) {
        Constructor<? extends RestishHandler<?>> sessionAware = ResultConfig.getConstructor(handlerClazz, Session.class);
        if (sessionAware != null) {
            return sessionId -> (RestishHandler)sessionAware.newInstance(sessionId != null ? this.sessions.get(sessionId) : null);
        }
        Constructor<? extends RestishHandler<?>> driverSessions = ResultConfig.getConstructor(handlerClazz, DriverSessions.class);
        if (driverSessions != null) {
            return sessionId -> (RestishHandler)driverSessions.newInstance(this.sessions);
        }
        Constructor<? extends RestishHandler<?>> noArgs = ResultConfig.getConstructor(handlerClazz, new Class[0]);
        if (noArgs != null) {
            return sessionId -> (RestishHandler)noArgs.newInstance(new Object[0]);
        }
        throw new IllegalArgumentException("Don't know how to construct " + handlerClazz);
    }

    private static Constructor<? extends RestishHandler<?>> getConstructor(Class<? extends RestishHandler<?>> handlerClazz, Class<?> ... types) {
        try {
            return handlerClazz.getConstructor(types);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultConfig)) {
            return false;
        }
        ResultConfig that = (ResultConfig)o;
        return this.commandName.equals(that.commandName);
    }

    public int hashCode() {
        return this.commandName.hashCode();
    }

    static interface HandlerFactory {
        public RestishHandler<?> createHandler(SessionId var1) throws Exception;
    }
}

