/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.html5;

import java.lang.reflect.InvocationTargetException;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.html5.ApplicationCache;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.mobile.NetworkConnection;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.html5.RemoteApplicationCache;
import org.openqa.selenium.remote.html5.RemoteLocationContext;
import org.openqa.selenium.remote.html5.RemoteWebStorage;
import org.openqa.selenium.remote.mobile.RemoteNetworkConnection;

public class Utils {
    static ApplicationCache getApplicationCache(WebDriver driver) {
        return (ApplicationCache)Utils.convert(driver, ApplicationCache.class, "applicationCacheEnabled", RemoteApplicationCache.class);
    }

    public static NetworkConnection getNetworkConnection(WebDriver driver) {
        return (NetworkConnection)Utils.convert(driver, NetworkConnection.class, "networkConnectionEnabled", RemoteNetworkConnection.class);
    }

    static LocationContext getLocationContext(WebDriver driver) {
        return (LocationContext)Utils.convert(driver, LocationContext.class, "locationContextEnabled", RemoteLocationContext.class);
    }

    static WebStorage getWebStorage(WebDriver driver) {
        return (WebStorage)Utils.convert(driver, WebStorage.class, "webStorageEnabled", RemoteWebStorage.class);
    }

    private static <T> T convert(WebDriver driver, Class<T> interfaceClazz, String capability, Class<? extends T> remoteImplementationClazz) {
        if (interfaceClazz.isInstance(driver)) {
            return interfaceClazz.cast(driver);
        }
        if (driver instanceof ExecuteMethod && driver instanceof HasCapabilities && ((HasCapabilities)driver).getCapabilities().is(capability)) {
            try {
                return remoteImplementationClazz.getConstructor(ExecuteMethod.class).newInstance((ExecuteMethod)driver);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
            }
            catch (ReflectiveOperationException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        throw new UnsupportedCommandException("driver (" + driver.getClass().getName() + ") does not support " + interfaceClazz.getName());
    }
}

