/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.interactions.internal.Locatable;

public class KnownElements {
    private final BiMap<String, WebElement> elements = HashBiMap.create();
    private int nextId;

    public String add(WebElement element) {
        if (this.elements.containsValue((Object)element)) {
            return (String)this.elements.inverse().get((Object)element);
        }
        String id = this.getNextId();
        this.elements.put((Object)id, (Object)this.proxyElement(element, id));
        return id;
    }

    public WebElement get(String elementId) {
        return (WebElement)this.elements.get((Object)elementId);
    }

    private String getNextId() {
        return String.valueOf(this.nextId++);
    }

    private WebElement proxyElement(final WebElement element, final String id) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
                if ("getId".equals(method.getName())) {
                    return id;
                }
                if ("getWrappedElement".equals(method.getName())) {
                    return element;
                }
                try {
                    return method.invoke((Object)element, objects);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        };
        Class[] proxyThese = element instanceof Locatable ? new Class[]{WebElement.class, ProxiedElement.class, Locatable.class} : new Class[]{WebElement.class, ProxiedElement.class};
        return (WebElement)Proxy.newProxyInstance(element.getClass().getClassLoader(), proxyThese, handler);
    }

    public static interface ProxiedElement
    extends WrapsElement {
        public String getId();
    }
}

