/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.html5.ApplicationCache;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.mobile.NetworkConnection;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DriverFactory;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.SnapshotScreenListener;
import org.openqa.selenium.support.events.EventFiringWebDriver;

public class DefaultSession
implements Session {
    private static final String QUIET_EXCEPTIONS_KEY = "webdriver.remote.quietExceptions";
    private final SessionId sessionId;
    private final WebDriver driver;
    private final KnownElements knownElements = new KnownElements();
    private final Map<String, Object> capabilities;
    private volatile String base64EncodedImage;
    private TemporaryFilesystem tempFs;

    public static Session createSession(DriverFactory factory, TemporaryFilesystem tempFs, Capabilities capabilities) throws Exception {
        return new DefaultSession(factory, tempFs, capabilities);
    }

    private DefaultSession(DriverFactory factory, TemporaryFilesystem tempFs, Capabilities capabilities) throws Exception {
        this.tempFs = tempFs;
        BrowserCreator browserCreator = new BrowserCreator(factory, capabilities);
        EventFiringWebDriver initialDriver = browserCreator.call();
        if (!DefaultSession.isQuietModeEnabled(browserCreator, capabilities)) {
            initialDriver.register(new SnapshotScreenListener(this));
        }
        this.driver = initialDriver;
        this.capabilities = browserCreator.getCapabilityDescription();
        this.sessionId = browserCreator.getSessionId();
    }

    private static boolean isQuietModeEnabled(BrowserCreator browserCreator, Capabilities capabilities) {
        if (browserCreator.isAndroid()) {
            return true;
        }
        boolean propertySaysQuiet = "true".equalsIgnoreCase(System.getProperty(QUIET_EXCEPTIONS_KEY));
        if (capabilities == null) {
            return propertySaysQuiet;
        }
        if (capabilities.is(QUIET_EXCEPTIONS_KEY)) {
            return true;
        }
        Object cap = capabilities.asMap().get(QUIET_EXCEPTIONS_KEY);
        boolean isExplicitlyDisabledByCapability = cap != null && "false".equalsIgnoreCase(cap.toString());
        return propertySaysQuiet && !isExplicitlyDisabledByCapability;
    }

    @Override
    public void close() {
        try {
            WebDriver driver = this.getDriver();
            if (driver != null) {
                driver.close();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (this.tempFs != null) {
            this.tempFs.deleteTemporaryFiles();
            this.tempFs.deleteBaseDir();
            this.tempFs = null;
        }
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    @Override
    public KnownElements getKnownElements() {
        return this.knownElements;
    }

    @Override
    public Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void attachScreenshot(String base64EncodedImage) {
        this.base64EncodedImage = base64EncodedImage;
    }

    @Override
    public String getAndClearScreenshot() {
        String temp = this.base64EncodedImage;
        this.base64EncodedImage = null;
        return temp;
    }

    @Override
    public SessionId getSessionId() {
        return this.sessionId;
    }

    @Override
    public TemporaryFilesystem getTemporaryFileSystem() {
        return this.tempFs;
    }

    private class BrowserCreator
    implements Callable<EventFiringWebDriver> {
        private final DriverFactory factory;
        private final Capabilities capabilities;
        private volatile Map<String, Object> describedCapabilities;
        private volatile SessionId sessionId;
        private volatile boolean isAndroid = false;

        BrowserCreator(DriverFactory factory, Capabilities capabilities) {
            this.factory = factory;
            this.capabilities = capabilities;
        }

        @Override
        public EventFiringWebDriver call() throws Exception {
            WebDriver rawDriver = this.factory.newInstance(this.capabilities);
            Capabilities actualCapabilities = this.capabilities;
            if (rawDriver instanceof HasCapabilities) {
                actualCapabilities = ((HasCapabilities)rawDriver).getCapabilities();
                this.isAndroid = actualCapabilities.getPlatform().is(Platform.ANDROID);
            }
            this.describedCapabilities = this.getDescription(rawDriver, actualCapabilities);
            this.sessionId = rawDriver instanceof RemoteWebDriver ? ((RemoteWebDriver)rawDriver).getSessionId() : new SessionId(UUID.randomUUID().toString());
            return new EventFiringWebDriver(rawDriver);
        }

        public Map<String, Object> getCapabilityDescription() {
            return this.describedCapabilities;
        }

        public SessionId getSessionId() {
            return this.sessionId;
        }

        public boolean isAndroid() {
            return this.isAndroid;
        }

        private Map<String, Object> getDescription(WebDriver instance, Capabilities capabilities) {
            DesiredCapabilities caps = new DesiredCapabilities(capabilities.asMap());
            caps.setJavascriptEnabled(instance instanceof JavascriptExecutor);
            if (instance instanceof TakesScreenshot) {
                caps.setCapability("takesScreenshot", true);
            }
            if (instance instanceof LocationContext) {
                caps.setCapability("locationContextEnabled", true);
            }
            if (instance instanceof ApplicationCache) {
                caps.setCapability("applicationCacheEnabled", true);
            }
            if (instance instanceof NetworkConnection) {
                caps.setCapability("networkConnectionEnabled", true);
            }
            if (instance instanceof WebStorage) {
                caps.setCapability("webStorageEnabled", true);
            }
            if (instance instanceof FindsByCssSelector) {
                caps.setCapability("cssSelectorsEnabled", true);
            }
            if (instance instanceof Rotatable) {
                caps.setCapability("rotatable", true);
            }
            if (instance instanceof HasTouchScreen) {
                caps.setCapability("hasTouchScreen", true);
            }
            return caps.asMap();
        }
    }
}

