/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.UrlTemplate;
import org.openqa.selenium.injector.Injector;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.ActiveSessions;
import org.openqa.selenium.remote.server.NewSessionPipeline;
import org.openqa.selenium.remote.server.commandhandler.BeginSession;
import org.openqa.selenium.remote.server.commandhandler.GetAllSessions;
import org.openqa.selenium.remote.server.commandhandler.GetLogTypes;
import org.openqa.selenium.remote.server.commandhandler.GetLogsOfType;
import org.openqa.selenium.remote.server.commandhandler.NoHandler;
import org.openqa.selenium.remote.server.commandhandler.NoSessionHandler;
import org.openqa.selenium.remote.server.commandhandler.Status;
import org.openqa.selenium.remote.server.commandhandler.UploadFile;

class AllHandlers {
    private final Json json;
    private final ActiveSessions allSessions;
    private final Injector parentInjector;
    private final Map<HttpMethod, ImmutableList<Function<String, CommandHandler>>> additionalHandlers;

    public AllHandlers(NewSessionPipeline pipeline, ActiveSessions allSessions) {
        this.allSessions = Objects.requireNonNull(allSessions);
        this.json = new Json();
        this.parentInjector = Injector.builder().register(this.json).register(allSessions).register(pipeline).build();
        this.additionalHandlers = ImmutableMap.of((Object)HttpMethod.DELETE, (Object)ImmutableList.of(), (Object)HttpMethod.GET, (Object)ImmutableList.of(this.handler("/session/{sessionId}/log/types", GetLogTypes.class), this.handler("/sessions", GetAllSessions.class), this.handler("/status", Status.class)), (Object)HttpMethod.POST, (Object)ImmutableList.of(this.handler("/session", BeginSession.class), this.handler("/session/{sessionId}/file", UploadFile.class), this.handler("/session/{sessionId}/log", GetLogsOfType.class), this.handler("/session/{sessionId}/se/file", UploadFile.class)));
    }

    public CommandHandler match(HttpServletRequest req) {
        String path = Strings.isNullOrEmpty((String)req.getPathInfo()) ? "/" : req.getPathInfo();
        Optional<CommandHandler> additionalHandler = this.additionalHandlers.get(HttpMethod.valueOf((String)req.getMethod())).stream().map(bundle -> (CommandHandler)bundle.apply(req.getPathInfo())).filter(Objects::nonNull).findFirst();
        if (additionalHandler.isPresent()) {
            return additionalHandler.get();
        }
        SessionId id = null;
        List fragments = Splitter.on((char)'/').limit(4).splitToList((CharSequence)path);
        if (fragments.size() > 2 && "session".equals(fragments.get(1))) {
            id = new SessionId((String)fragments.get(2));
        }
        if (id != null) {
            ActiveSession session = this.allSessions.get(id);
            if (session == null) {
                return new NoSessionHandler(this.json, id);
            }
            return session;
        }
        return new NoHandler(this.json);
    }

    private <H extends CommandHandler> Function<String, CommandHandler> handler(String template, Class<H> handler) {
        UrlTemplate urlTemplate = new UrlTemplate(template);
        return path -> {
            UrlTemplate.Match match = urlTemplate.match((String)path);
            if (match == null) {
                return null;
            }
            Injector.Builder child = Injector.builder().parent(this.parentInjector);
            if (match.getParameters().containsKey("sessionId")) {
                SessionId id = new SessionId(match.getParameters().get("sessionId"));
                child.register(id);
                ActiveSession session = this.allSessions.get(id);
                if (session != null) {
                    child.register(session);
                    child.register(session.getFileSystem());
                }
            }
            match.getParameters().entrySet().stream().filter(e -> !"sessionId".equals(e.getKey())).forEach(e -> child.register(e.getValue()));
            return (CommandHandler)child.build().newInstance(handler);
        };
    }
}

