/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import com.thoughtworks.selenium.webdriven.WebDriverBackedSelenium;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.internal.SocketLock;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.server.htmlrunner.CoreTestSuite;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;
import org.openqa.selenium.server.htmlrunner.Results;
import org.seleniumhq.jetty9.server.ConnectionFactory;
import org.seleniumhq.jetty9.server.Connector;
import org.seleniumhq.jetty9.server.Handler;
import org.seleniumhq.jetty9.server.HttpConfiguration;
import org.seleniumhq.jetty9.server.HttpConnectionFactory;
import org.seleniumhq.jetty9.server.Server;
import org.seleniumhq.jetty9.server.ServerConnector;
import org.seleniumhq.jetty9.server.handler.ContextHandler;
import org.seleniumhq.jetty9.server.handler.ResourceHandler;
import org.seleniumhq.jetty9.util.resource.Resource;

public class HTMLLauncher
implements HTMLResultsListener {
    private static Logger log = Logger.getLogger(HTMLLauncher.class.getName());
    private Server server;

    public String runHTMLSuite(String browser, String browserURL, String suiteURL, File outputFile, long timeoutInSeconds, boolean multiWindow) throws IOException {
        return this.runHTMLSuite(browser, browserURL, suiteURL, outputFile, timeoutInSeconds, multiWindow, "info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runHTMLSuite(String browser, String browserURL, String suiteURL, File outputFile, long timeoutInSeconds, boolean multiWindow, String defaultLogLevel) throws IOException {
        File parent = outputFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        if (outputFile.exists() && !outputFile.canWrite()) {
            throw new IOException("Can't write to outputFile: " + outputFile.getAbsolutePath());
        }
        long timeoutInMs = 1000L * timeoutInSeconds;
        if (timeoutInMs < 0L) {
            log.warning("Looks like the timeout overflowed, so resetting it to the maximum.");
            timeoutInMs = Long.MAX_VALUE;
        }
        WebDriver driver = null;
        try {
            driver = this.createDriver(browser);
            URL suiteUrl = this.determineSuiteUrl(browserURL, suiteURL);
            driver.get(suiteUrl.toString());
            WebDriverBackedSelenium selenium = new WebDriverBackedSelenium(driver, browserURL);
            List allTables = driver.findElements(By.id((String)"suiteTable"));
            if (allTables.isEmpty()) {
                throw new RuntimeException("Unable to find suite table: " + driver.getPageSource());
            }
            Results results = new CoreTestSuite(suiteUrl.toString()).run(driver, selenium);
            HTMLTestResults htmlResults = results.toSuiteResult();
            try (BufferedWriter writer = Files.newBufferedWriter(outputFile.toPath(), new OpenOption[0]);){
                htmlResults.write(writer);
            }
            String string = results.isSuccessful() ? "PASSED" : "FAILED";
            return string;
        }
        finally {
            if (this.server != null) {
                try {
                    this.server.stop();
                }
                catch (Exception e) {
                    log.log(Level.INFO, "Exception shutting down server. You may ignore this.", e);
                }
            }
            if (driver != null) {
                driver.quit();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL determineSuiteUrl(String browserUrl, String suiteURL) throws IOException {
        Object url = null;
        if (suiteURL.startsWith("https://")) return this.verifySuiteUrl(new URL(suiteURL));
        if (suiteURL.startsWith("http://")) {
            return this.verifySuiteUrl(new URL(suiteURL));
        }
        Path path = Paths.get(suiteURL, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            URL browser = new URL(browserUrl);
            return this.verifySuiteUrl(new URL(browser, suiteURL));
        }
        try (SocketLock lock = new SocketLock();){
            this.server = new Server();
            HttpConfiguration httpConfig = new HttpConfiguration();
            ServerConnector http = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            int port = PortProber.findFreePort();
            http.setPort(port);
            http.setIdleTimeout(500000L);
            this.server.setConnectors(new Connector[]{http});
            ResourceHandler handler = new ResourceHandler();
            handler.setDirectoriesListed(true);
            handler.setWelcomeFiles(new String[]{"index.html"});
            handler.setBaseResource(Resource.newResource((File)path.toFile()));
            ContextHandler context = new ContextHandler("/tests");
            context.setHandler((Handler)handler);
            this.server.setHandler((Handler)handler);
            this.server.start();
            PortProber.pollPort((int)port);
            URL serverUrl = this.server.getURI().toURL();
            URL uRL = new URL(serverUrl.getProtocol(), serverUrl.getHost(), serverUrl.getPort(), "/tests/");
            return uRL;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private URL verifySuiteUrl(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new IOException("The HTMLLauncher only supports relative HTTP URLs");
        }
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        httpConnection.setInstanceFollowRedirects(true);
        httpConnection.setRequestMethod("HEAD");
        int responseCode = httpConnection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Invalid suite URL: " + url);
        }
        return url;
    }

    @Override
    public void processResults(HTMLTestResults resultsParm) {
    }

    public static int mainInt(String ... args) throws Exception {
        if (args.length != 5 && args.length != 4) {
            throw new IllegalAccessException("Usage: HTMLLauncher outputDir testSuite startUrl multiWindow browser");
        }
        File dir = new File(args[0]);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Cannot create output directory for: " + dir);
        }
        String suite = args[1];
        String startURL = args[2];
        boolean multiWindow = Boolean.parseBoolean(args[3]);
        String[] browsers = new String[]{args[4]};
        HTMLLauncher launcher = new HTMLLauncher();
        boolean passed = true;
        for (String browser : browsers) {
            File results = new File(dir, browser.substring(1) + ".results");
            String result = "FAILED";
            try {
                result = launcher.runHTMLSuite(browser, startURL, suite, results, 600L, multiWindow);
                passed &= "PASSED".equals(result);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Test of browser failed: " + browser, e);
                passed = false;
            }
        }
        return passed ? 1 : 0;
    }

    public static void main(String[] args) throws Exception {
        System.exit(HTMLLauncher.mainInt(args));
    }

    private WebDriver createDriver(String browser) {
        switch (browser) {
            case "*chrome": 
            case "*firefox": 
            case "*firefoxproxy": 
            case "*firefoxchrome": 
            case "*pifirefox": {
                DesiredCapabilities caps = new DesiredCapabilities();
                caps.setCapability("marionette", true);
                return new FirefoxDriver((Capabilities)caps);
            }
            case "*iehta": 
            case "*iexplore": 
            case "*iexploreproxy": 
            case "*piiexplore": {
                return new InternetExplorerDriver();
            }
            case "*googlechrome": {
                return new ChromeDriver();
            }
            case "*MicrosoftEdge": {
                return new EdgeDriver();
            }
            case "*opera": 
            case "*operablink": {
                return new OperaDriver();
            }
            case "*safari": 
            case "*safariproxy": {
                return new SafariDriver();
            }
        }
        throw new RuntimeException("Unrecognized browser: " + browser);
    }
}

