/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonTypeCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

class NumberCoercer<T extends Number>
extends TypeCoercer<T> {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_NUMBER_TYPES = Map.ofEntries(Map.entry(Byte.TYPE, Byte.class), Map.entry(Double.TYPE, Double.class), Map.entry(Float.TYPE, Float.class), Map.entry(Integer.TYPE, Integer.class), Map.entry(Long.TYPE, Long.class), Map.entry(Short.TYPE, Short.class));
    private final JsonTypeCoercer typeCoercer;
    private final Class<T> stereotype;
    private final Function<Number, T> mapper;

    NumberCoercer(JsonTypeCoercer typeCoercer, Class<T> stereotype, Function<Number, T> mapper) {
        this.typeCoercer = (JsonTypeCoercer)Require.nonNull((String)"TypeCoercer", (Object)typeCoercer);
        this.stereotype = (Class)Require.nonNull((String)"Stereotype", stereotype);
        this.mapper = (Function)Require.nonNull((String)"Mapper", mapper);
    }

    @Override
    public boolean test(Class<?> type) {
        return this.stereotype.isAssignableFrom(PRIMITIVE_NUMBER_TYPES.getOrDefault(type, type));
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, T> apply(Type ignored) {
        return (jsonInput, setting) -> {
            Number number;
            switch (jsonInput.peek()) {
                case NUMBER: {
                    number = jsonInput.nextNumber();
                    break;
                }
                case STRING: {
                    String numberAsString = jsonInput.nextString();
                    try (JsonInput nestedInput = new JsonInput(new StringReader(numberAsString), this.typeCoercer, (PropertySetting)((Object)setting));){
                        number = nestedInput.nextNumber();
                        nestedInput.nextEnd();
                        break;
                    }
                    catch (JsonException e) {
                        throw new JsonException(String.format("Not a numeric value: \"%s\"", numberAsString), (Throwable)((Object)e));
                    }
                }
                default: {
                    throw new JsonException("Unable to coerce to a number: " + String.valueOf((Object)jsonInput.peek()));
                }
            }
            return (Number)this.mapper.apply(number);
        };
    }
}

