/*
Copyright 2013 Selenium committers
Copyright 2013 Software Freedom Conservancy

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package com.thoughtworks.selenium.webdriven.commands;

import com.thoughtworks.selenium.webdriven.SeleneseCommand;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Actions;

public class KeyPressNative extends SeleneseCommand<Void> {
  @Override
  protected Void handleSeleneseCommand(WebDriver driver, String keyCode, String ignored) {
    System.out.println(keyCode);
    char[] chars = Character.toChars(Integer.parseInt(keyCode));
    System.out.println(chars);
    new Actions(driver).sendKeys(new String(chars)).perform();
    return null;
  }
}
