/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import com.google.common.collect.Maps;
import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.HttpCommandProcessor;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.internal.selenesedriver.ClearElement;
import org.openqa.selenium.internal.selenesedriver.ClickElement;
import org.openqa.selenium.internal.selenesedriver.Close;
import org.openqa.selenium.internal.selenesedriver.ExecuteAsyncScript;
import org.openqa.selenium.internal.selenesedriver.ExecuteScript;
import org.openqa.selenium.internal.selenesedriver.FindElement;
import org.openqa.selenium.internal.selenesedriver.FindElements;
import org.openqa.selenium.internal.selenesedriver.GetActiveElement;
import org.openqa.selenium.internal.selenesedriver.GetCurrentUrl;
import org.openqa.selenium.internal.selenesedriver.GetElementAttribute;
import org.openqa.selenium.internal.selenesedriver.GetElementText;
import org.openqa.selenium.internal.selenesedriver.GetElementValue;
import org.openqa.selenium.internal.selenesedriver.GetPageSource;
import org.openqa.selenium.internal.selenesedriver.GetSize;
import org.openqa.selenium.internal.selenesedriver.GetTagName;
import org.openqa.selenium.internal.selenesedriver.GetTitle;
import org.openqa.selenium.internal.selenesedriver.GetUrl;
import org.openqa.selenium.internal.selenesedriver.IsElementDisplayed;
import org.openqa.selenium.internal.selenesedriver.IsElementEnabled;
import org.openqa.selenium.internal.selenesedriver.IsElementSelected;
import org.openqa.selenium.internal.selenesedriver.NewSession;
import org.openqa.selenium.internal.selenesedriver.QuitSelenium;
import org.openqa.selenium.internal.selenesedriver.SeleneseFunction;
import org.openqa.selenium.internal.selenesedriver.SendKeys;
import org.openqa.selenium.internal.selenesedriver.SubmitElement;
import org.openqa.selenium.internal.selenesedriver.SwitchToFrame;
import org.openqa.selenium.internal.selenesedriver.TakeScreenshot;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;

public class SeleneseCommandExecutor
implements CommandExecutor {
    private final ErrorCodes errorCodes;
    private final Selenium instance;
    private Map<String, SeleneseFunction> functions = Maps.newHashMap();

    public SeleneseCommandExecutor(URL seleniumServer, URL remoteAddress, Capabilities capabilities) {
        this(new HttpCommandProcessor(seleniumServer.getHost(), seleniumServer.getPort(), SeleneseCommandExecutor.startCommand(capabilities), remoteAddress.toString()));
    }

    public SeleneseCommandExecutor(CommandProcessor processor) {
        this(new DefaultSelenium(processor));
    }

    public SeleneseCommandExecutor(Selenium instance) {
        this.instance = instance;
        this.errorCodes = new ErrorCodes();
        this.prepareCommands();
    }

    public Selenium getWrappedSelenium() {
        return this.instance;
    }

    public Response execute(Command command) {
        SeleneseFunction function = this.functions.get(command.getName());
        if (function == null) {
            throw new UnsupportedOperationException("cannot execute: " + command.getName());
        }
        try {
            Response response = new Response();
            response.setValue(function.apply(this.instance, command.getParameters()));
            return response;
        }
        catch (Exception e) {
            return this.prepareExceptionResponse(e);
        }
    }

    private Response prepareExceptionResponse(Exception e) {
        Response response = new Response();
        Exception toUse = e;
        if (e instanceof SeleniumException && e.getMessage().matches("ERROR: (Threw an exception: )?Element .+ not found")) {
            toUse = new StaleElementReferenceException(e.getMessage(), (Throwable)e);
        }
        response.setStatus(this.errorCodes.toStatusCode((Throwable)toUse));
        Object raw = new JsonToBeanConverter().convert(Map.class, (Object)new BeanToJsonConverter().convert((Object)toUse));
        response.setValue(raw);
        return response;
    }

    public void addCommand(String methodName, SeleneseFunction command) {
        this.functions.put(methodName, command);
    }

    private void prepareCommands() {
        FindElement findElement = new FindElement();
        FindElements findElements = new FindElements();
        SeleneseTimeouts timeouts = new SeleneseTimeouts(findElement.implicitlyWait(), findElements.implicitlyWait());
        ExecuteAsyncScript executeAsyncScript = new ExecuteAsyncScript();
        this.addCommand("clearElement", new ClearElement());
        this.addCommand("clickElement", new ClickElement());
        this.addCommand("close", new Close());
        this.addCommand("getCurrentUrl", new GetCurrentUrl());
        this.addCommand("executeScript", new ExecuteScript());
        this.addCommand("executeAsyncScript", executeAsyncScript);
        this.addCommand("setScriptTimeout", executeAsyncScript.setScriptTimeout());
        this.addCommand("findChildElement", findElement);
        this.addCommand("findChildElements", findElements);
        this.addCommand("findElement", findElement);
        this.addCommand("findElements", findElements);
        this.addCommand("implicitlyWait", timeouts);
        this.addCommand("get", new GetUrl());
        this.addCommand("getActiveElement", new GetActiveElement());
        this.addCommand("getElementAttribute", new GetElementAttribute());
        this.addCommand("getElementSize", new GetSize());
        this.addCommand("getElementText", new GetElementText());
        this.addCommand("getElementValue", new GetElementValue());
        this.addCommand("getElementTagName", new GetTagName());
        this.addCommand("getTitle", new GetTitle());
        this.addCommand("isElementDisplayed", new IsElementDisplayed());
        this.addCommand("isElementEnabled", new IsElementEnabled());
        this.addCommand("isElementSelected", new IsElementSelected());
        this.addCommand("newSession", new NewSession());
        this.addCommand("getPageSource", new GetPageSource());
        this.addCommand("screenshot", new TakeScreenshot());
        this.addCommand("sendKeysToElement", new SendKeys());
        this.addCommand("switchToFrame", new SwitchToFrame());
        this.addCommand("submitElement", new SubmitElement());
        this.addCommand("quit", new QuitSelenium());
    }

    private static String startCommand(Capabilities capabilities) {
        String browser = capabilities.getBrowserName();
        if (DesiredCapabilities.firefox().getBrowserName().equals(browser)) {
            return "*chrome";
        }
        if ("safari".equals(browser)) {
            String path = SeleneseCommandExecutor.findSafari();
            return "*safari " + path;
        }
        if (DesiredCapabilities.chrome().getBrowserName().equals(browser)) {
            return "*googlechrome /Applications/Google Chrome.app/Contents/MacOS/Google Chrome";
        }
        throw new IllegalArgumentException("Cannot determine which selenium type to use: " + capabilities.getBrowserName());
    }

    private static String findSafari() {
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            File[] locations;
            for (File location : locations = new File[]{new File("C:\\Program Files (x86)\\Safari\\safari.exe"), new File("C:\\Program Files\\Safari\\safari.exe")}) {
                if (!location.exists()) continue;
                return location.getAbsolutePath();
            }
        }
        return "";
    }

    private class SeleneseTimeouts
    implements SeleneseFunction<Void> {
        private final SeleneseFunction<Object>[] functions;

        public SeleneseTimeouts(SeleneseFunction<Object> ... functions) {
            this.functions = functions;
        }

        @Override
        public Void apply(Selenium selenium, Map<String, ?> args) {
            for (SeleneseFunction<Object> function : this.functions) {
                function.apply(selenium, args);
            }
            return null;
        }
    }
}

