/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.iphone;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.remote.internal.CircularOutputStream;

public class IPhoneSimulatorBinary {
    private static final String IPHONE_LOG_FILE_PROPERTY = "webdriver.iphone.logFile";
    private final CommandLine commandLine;
    private Integer exitCode = null;

    public IPhoneSimulatorBinary(File iWebDriverApp) {
        System.out.println(String.format("%s launch %s --exit", IPhoneSimulatorBinary.getIphoneSimPath(), iWebDriverApp.getParentFile().getAbsoluteFile()));
        this.commandLine = CommandLine.parse((String)String.format("%s launch %s --exit", IPhoneSimulatorBinary.getIphoneSimPath(), iWebDriverApp.getParentFile().getAbsoluteFile()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getIphoneSimPath() {
        String string;
        String filename = "ios-sim";
        File parentDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("webdriver", "libs");
        File destination = new File(parentDir, filename);
        FileOutputStream outputStream = new FileOutputStream(destination);
        try {
            URL resource = Resources.getResource((String)(IPhoneSimulatorBinary.class.getPackage().getName().replace('.', '/') + '/' + filename));
            Resources.copy((URL)resource, (OutputStream)outputStream);
            FileHandler.makeExecutable((File)destination);
            string = destination.getAbsolutePath();
        }
        catch (Throwable throwable) {
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        outputStream.close();
        return string;
    }

    private static OutputStream createOutputStream() {
        String logFileString = System.getProperty(IPHONE_LOG_FILE_PROPERTY);
        File logFile = logFileString == null ? null : new File(logFileString);
        return new CircularOutputStream(logFile);
    }

    public void launch() {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(IPhoneSimulatorBinary.createOutputStream()));
        try {
            this.exitCode = executor.execute(this.commandLine);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRunning() {
        return this.exitCode != null && this.exitCode == 0;
    }

    public void shutdown() {
        try {
            File scriptFile = File.createTempFile("iWebDriver.kill.", ".script");
            FileWriter writer = new FileWriter(scriptFile);
            writer.write("ps ax | grep 'iPhone Simulator' | grep -v grep | awk '{print $1}' | xargs kill");
            writer.flush();
            writer.close();
            FileHandler.makeExecutable((File)scriptFile);
            CommandLine killCommandLine = CommandLine.parse((String)scriptFile.getAbsolutePath());
            DefaultExecutor executor = new DefaultExecutor();
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(null, null));
            IPhoneSimulatorBinary.getOutputIgnoringExecutor().execute(killCommandLine);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.exitCode = null;
    }

    private static Executor getOutputIgnoringExecutor() {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(null, null));
        return executor;
    }
}

