/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.ImmutableMap;
import dev.failsafe.Failsafe;
import dev.failsafe.Fallback;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.event.ExecutionAttemptedEvent;
import java.net.ConnectException;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class RetryRequest
implements Filter {
    private static final Logger LOG = Logger.getLogger(RetryRequest.class.getName());
    private static final Fallback<HttpResponse> fallback = Fallback.of(RetryRequest::getFallback);
    private static final RetryPolicy<HttpResponse> connectionFailurePolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handleIf(failure -> failure.getCause() instanceof ConnectException)).withMaxRetries(3).onRetry(e -> LOG.log(Debug.getDebugLogLevel(), "Connection failure #{0}. Retrying.", e.getAttemptCount())).build();
    private static final RetryPolicy<HttpResponse> readTimeoutPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handle(TimeoutException.class)).withMaxRetries(3).onRetry(e -> LOG.log(Debug.getDebugLogLevel(), "Read timeout #{0}. Retrying.", e.getAttemptCount())).build();
    private static final RetryPolicy<HttpResponse> serverErrorPolicy = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handleResultIf(response -> response.getStatus() == 500 && Integer.parseInt(response.getHeader("Content-Length")) == 0)).handleResultIf(response -> response.getStatus() == 503)).withMaxRetries(2).onRetry(e -> LOG.log(Debug.getDebugLogLevel(), "Failure due to server error #{0}. Retrying.", e.getAttemptCount())).build();

    @Override
    public HttpHandler apply(HttpHandler next) {
        return req -> (HttpResponse)Failsafe.with(fallback, (Policy[])new Fallback[0]).compose(serverErrorPolicy).compose(readTimeoutPolicy).compose(connectionFailurePolicy).get(() -> next.execute(req));
    }

    private static HttpResponse getFallback(ExecutionAttemptedEvent<? extends HttpResponse> executionAttemptedEvent) throws Exception {
        HttpResponse response;
        if (executionAttemptedEvent.getLastException() != null) {
            Exception exception = (Exception)executionAttemptedEvent.getLastException();
            if (exception.getCause() instanceof ConnectException) {
                return (HttpResponse)new HttpResponse().setStatus(408).setContent((Supplier)Contents.asJson(ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"message", (Object)"Connection failure"))));
            }
            if (exception instanceof TimeoutException) {
                return (HttpResponse)new HttpResponse().setStatus(504).setContent((Supplier)Contents.asJson(ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"message", (Object)"Read timeout"))));
            }
            throw exception;
        }
        if (executionAttemptedEvent.getLastResult() != null && ((response = (HttpResponse)executionAttemptedEvent.getLastResult()).getStatus() == 500 && Integer.parseInt(response.getHeader("Content-Length")) == 0 || response.getStatus() == 503)) {
            return (HttpResponse)new HttpResponse().setStatus(response.getStatus()).setContent((Supplier)Contents.asJson(ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"message", (Object)"Internal server error"))));
        }
        return (HttpResponse)executionAttemptedEvent.getLastResult();
    }
}

