/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.base.Preconditions;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.Filter;

public class ClientConfig {
    private static final AddSeleniumUserAgent DEFAULT_FILTER = new AddSeleniumUserAgent();
    private final URI baseUri;
    private final Duration connectionTimeout;
    private final Duration readTimeout;
    private final Filter filters;
    private final Proxy proxy;

    private ClientConfig(URI baseUri, Duration connectionTimeout, Duration readTimeout, Filter filters, Proxy proxy) {
        this.baseUri = baseUri;
        this.connectionTimeout = Objects.requireNonNull(connectionTimeout, "Connection timeout must be set.");
        this.readTimeout = Objects.requireNonNull(readTimeout, "Connection timeout must be set.");
        this.filters = Objects.requireNonNull(filters, "Filters must be set.");
        this.proxy = proxy;
        Preconditions.checkArgument((!readTimeout.isNegative() ? 1 : 0) != 0, (Object)"Read time out cannot be negative");
        Preconditions.checkArgument((!connectionTimeout.isNegative() ? 1 : 0) != 0, (Object)"Connection time out cannot be negative");
    }

    public static ClientConfig defaultConfig() {
        return new ClientConfig(null, Duration.ofMinutes(2L), Duration.ofHours(3L), new AddSeleniumUserAgent(), null);
    }

    public ClientConfig baseUri(URI baseUri) {
        Objects.requireNonNull(baseUri, "Base URI to use must be set.");
        return new ClientConfig(baseUri, this.connectionTimeout, this.readTimeout, this.filters, this.proxy);
    }

    public ClientConfig baseUrl(URL baseUrl) {
        Objects.requireNonNull(baseUrl, "Base URL to use must be set.");
        try {
            return this.baseUri(baseUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI baseUri() {
        return this.baseUri;
    }

    public URL baseUrl() {
        try {
            return this.baseUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ClientConfig connectionTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "Connection timeout must be set.");
        return new ClientConfig(this.baseUri, timeout, this.readTimeout, this.filters, this.proxy);
    }

    public Duration connectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientConfig readTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "Read timeout must be set.");
        return new ClientConfig(this.baseUri, this.connectionTimeout, timeout, this.filters, this.proxy);
    }

    public Duration readTimeout() {
        return this.readTimeout;
    }

    public ClientConfig withFilter(Filter filter) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, filter == null ? DEFAULT_FILTER : filter.andThen(DEFAULT_FILTER), this.proxy);
    }

    public Filter filter() {
        return this.filters;
    }

    public ClientConfig proxy(Proxy proxy) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.filters, proxy);
    }

    public Proxy proxy() {
        return this.proxy;
    }
}

