/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.docker;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.grid.config.ConfigValue;
import org.openqa.selenium.grid.config.HasRoles;
import org.openqa.selenium.grid.config.NonSplittingSplitter;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;

@AutoService(value={HasRoles.class})
public class DockerFlags
implements HasRoles {
    @Parameter(names={"--docker-url"}, description="URL for connecting to the docker daemon")
    @ConfigValue(section="docker", name="url", example={"\"unix:/var/run/docker.sock\""})
    private String dockerUrl;
    @Parameter(names={"--docker-host"}, description="Host name where the docker daemon is running")
    @ConfigValue(section="docker", name="host", example={"\"localhost\""})
    private String dockerHost;
    @Parameter(names={"--docker-port"}, description="Port where the docker daemon is running")
    @ConfigValue(section="docker", name="port", example={"2375"})
    private Integer dockerPort;
    @Parameter(names={"--docker", "-D"}, description="Docker configs which map image name to stereotype capabilities (example: -D selenium/standalone-firefox:latest '{\"browserName\": \"firefox\"}')", arity=2, variableArity=true, splitter=NonSplittingSplitter.class)
    @ConfigValue(section="docker", name="configs", example={"[\"selenium/standalone-firefox:latest\", \"{\\\"browserName\\\": \\\"firefox\\\"}\"]"})
    private List<String> images2Capabilities;
    @Parameter(names={"--docker-devices"}, description="Exposes devices to a container. Each device mapping declaration must have  at least the path of the device in both host and container separated by a colon like in this example: /device/path/in/host:/device/path/in/container", arity=1, variableArity=true, splitter=NonSplittingSplitter.class)
    @ConfigValue(section="docker", name="devices", example={"[\"/dev/kvm:/dev/kvm\"]"})
    private List<String> devices;
    @Parameter(names={"--docker-video-image"}, description="Docker image to be used when video recording is enabled")
    @ConfigValue(section="docker", name="video-image", example={"selenium/video:latest"})
    private String videoImage = "selenium/video:latest";
    @Parameter(names={"--docker-assets-path"}, description="Absolute path where assets will be stored")
    @ConfigValue(section="docker", name="assets-path", example={"\"/opt/selenium/assets\""})
    private String assetsPath;

    public Set<Role> getRoles() {
        return Collections.singleton(StandardGridRoles.NODE_ROLE);
    }
}

