/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.httpd;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.TemplateGridServerCommand;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.MemoizedConfig;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeAddedEvent;
import org.openqa.selenium.grid.data.NodeDrainComplete;
import org.openqa.selenium.grid.data.NodeRemovedEvent;
import org.openqa.selenium.grid.data.NodeStatusEvent;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.node.HealthCheck;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.ProxyNodeWebsockets;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.grid.node.httpd.DefaultNodeConfig;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;

@AutoService(value={CliCommand.class})
public class NodeServer
extends TemplateGridServerCommand {
    private static final Logger LOG = Logger.getLogger(NodeServer.class.getName());
    private final AtomicBoolean nodeRegistered = new AtomicBoolean(false);
    private Node node;
    private EventBus bus;
    private final Thread shutdownHook = new Thread(() -> this.bus.fire(new NodeRemovedEvent(this.node.getStatus())));

    @Override
    public String getName() {
        return "node";
    }

    @Override
    public String getDescription() {
        return "Adds this server as a Node in the Selenium Grid.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.EVENT_BUS_ROLE, (Object)StandardGridRoles.HTTPD_ROLE, (Object)StandardGridRoles.NODE_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "node";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultNodeConfig();
    }

    @Override
    protected TemplateGridServerCommand.Handlers createHandlers(Config config) {
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        EventBusOptions events = new EventBusOptions(config);
        this.bus = events.getEventBus();
        NetworkOptions networkOptions = new NetworkOptions(config);
        HttpClient.Factory clientFactory = networkOptions.getHttpClientFactory(tracer);
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        LOG.info("Reporting self as: " + serverOptions.getExternalUri());
        NodeOptions nodeOptions = new NodeOptions(config);
        this.node = nodeOptions.getNode();
        HttpHandler readinessCheck = req -> {
            if (this.node.getStatus().hasCapacity()) {
                return new HttpResponse().setStatus(204);
            }
            return (HttpResponse)((HttpResponse)new HttpResponse().setStatus(503).setHeader("Content-Type", MediaType.PLAIN_TEXT_UTF_8.toString())).setContent(Contents.utf8String((CharSequence)"No capacity available"));
        };
        this.bus.addListener(NodeAddedEvent.listener(nodeId -> {
            if (this.node.getId().equals(nodeId)) {
                this.nodeRegistered.set(true);
                LOG.info("Node has been added");
            }
        }));
        this.bus.addListener(NodeDrainComplete.listener(nodeId -> {
            if (!this.node.getId().equals(nodeId)) {
                return;
            }
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOG.info("Shutting down");
                System.exit(0);
            }, "Node shutdown: " + nodeId).start();
        }));
        Route httpHandler = Route.combine((Routable)this.node, (Routable[])new Routable[]{Route.get((String)"/readyz").to(() -> readinessCheck)});
        return new TemplateGridServerCommand.Handlers((HttpHandler)httpHandler, new ProxyNodeWebsockets(clientFactory, this.node));
    }

    @Override
    public Server<?> asServer(Config initialConfig) {
        Require.nonNull((String)"Config", (Object)initialConfig);
        MemoizedConfig config = new MemoizedConfig((Config)new CompoundConfig(new Config[]{initialConfig, this.getDefaultConfig()}));
        final NodeOptions nodeOptions = new NodeOptions((Config)config);
        TemplateGridServerCommand.Handlers handler = this.createHandlers((Config)config);
        return new NettyServer(new BaseServerOptions((Config)config), handler.httpHandler, handler.websocketHandler){

            @Override
            public NettyServer start() {
                super.start();
                RetryPolicy registrationPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().withMaxAttempts(-1).withMaxDuration(nodeOptions.getRegisterPeriod()).withDelay(nodeOptions.getRegisterCycle()).handleResultIf(result -> true)).build();
                LOG.info("Starting registration process for Node " + NodeServer.this.node.getUri());
                Executors.newSingleThreadExecutor().submit(() -> Failsafe.with((Policy)registrationPolicy, (Policy[])new RetryPolicy[0]).run(() -> {
                    if (NodeServer.this.nodeRegistered.get()) {
                        throw new InterruptedException("Stopping registration thread.");
                    }
                    HealthCheck.Result check = NodeServer.this.node.getHealthCheck().check();
                    if (Availability.DOWN.equals((Object)check.getAvailability())) {
                        LOG.severe("Node is not alive: " + check.getMessage());
                        throw new UnsupportedOperationException("Node cannot be registered");
                    }
                    NodeServer.this.bus.fire(new NodeStatusEvent(NodeServer.this.node.getStatus()));
                    LOG.info("Sending registration event...");
                }));
                return this;
            }
        };
    }

    @Override
    protected void execute(Config config) {
        Require.nonNull((String)"Config", (Object)config);
        config.get("server", "max-threads").ifPresent(value -> LOG.log(Level.WARNING, () -> "Support for max-threads flag is deprecated. The intent of the flag is to set the thread pool size in the Distributor. Please use newsession-threadpool-size flag instead."));
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        Server server = (Server)this.asServer(config).start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium node %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }
}

