/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.config;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.PersistentCapabilities;

public class SessionCapabilitiesMutator
implements Function<Capabilities, Capabilities> {
    private static final ImmutableMap<String, String> BROWSER_OPTIONS = ImmutableMap.of((Object)"chrome", (Object)"goog:chromeOptions", (Object)"firefox", (Object)"moz:firefoxOptions", (Object)"microsoftedge", (Object)"ms:edgeOptions");
    private static final String SE_VNC_ENABLED = "se:vncEnabled";
    private static final String SE_NO_VNC_PORT = "se:noVncPort";
    private final Capabilities slotStereotype;

    public SessionCapabilitiesMutator(Capabilities slotStereotype) {
        this.slotStereotype = slotStereotype;
    }

    @Override
    public Capabilities apply(Capabilities capabilities) {
        String browserName;
        if (!Objects.equals(this.slotStereotype.getBrowserName(), capabilities.getBrowserName())) {
            return capabilities;
        }
        if (this.slotStereotype.getCapability(SE_VNC_ENABLED) != null) {
            capabilities = new PersistentCapabilities(capabilities).setCapability(SE_VNC_ENABLED, this.slotStereotype.getCapability(SE_VNC_ENABLED)).setCapability(SE_NO_VNC_PORT, this.slotStereotype.getCapability(SE_NO_VNC_PORT));
        }
        if ("internet explorer".equalsIgnoreCase(browserName = capabilities.getBrowserName().toLowerCase())) {
            return new ImmutableCapabilities(this.removeUnknownExtensionsForIE(capabilities));
        }
        if (!BROWSER_OPTIONS.containsKey((Object)browserName)) {
            return capabilities;
        }
        String options = (String)BROWSER_OPTIONS.get((Object)browserName);
        if (this.slotStereotype.asMap().containsKey(options) && capabilities.asMap().containsKey(options)) {
            HashMap<String, Object> stereotypeOptions = new HashMap<String, Object>((Map)this.slotStereotype.asMap().get(options));
            HashMap<String, Object> capsOptions = new HashMap<String, Object>((Map)capabilities.asMap().get(options));
            HashMap<String, Map<String, Object>> toReturn = new HashMap<String, Map<String, Object>>(this.slotStereotype.merge(capabilities).asMap());
            switch (browserName.toLowerCase()) {
                case "chrome": 
                case "microsoftedge": 
                case "msedge": {
                    toReturn.put(options, this.mergeChromiumOptions(stereotypeOptions, capsOptions));
                    break;
                }
                case "firefox": {
                    toReturn.put(options, this.mergeFirefoxOptions(stereotypeOptions, capsOptions));
                    break;
                }
            }
            return new ImmutableCapabilities(toReturn);
        }
        return this.slotStereotype.merge(capabilities);
    }

    private Map<String, Object> removeUnknownExtensionsForIE(Capabilities capabilities) {
        HashMap<String, Object> toReturn = new HashMap<String, Object>(capabilities.asMap());
        capabilities.asMap().keySet().stream().filter(key -> key.contains(":")).filter(key -> !"se:ieOptions".equalsIgnoreCase((String)key)).forEach(toReturn::remove);
        return toReturn;
    }

    private Map<String, Object> mergeChromiumOptions(Map<String, Object> stereotypeOptions, Map<String, Object> capsOptions) {
        HashMap<String, Object> toReturn = new HashMap<String, Object>(stereotypeOptions);
        for (Map.Entry<String, Object> entry : capsOptions.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (name.equals("args")) {
                ArrayList arguments = new ArrayList((List)value);
                ArrayList stereotypeArguments = new ArrayList(stereotypeOptions.getOrDefault("args", new ArrayList()));
                arguments.forEach(arg -> {
                    if (!stereotypeArguments.contains(arg)) {
                        stereotypeArguments.add(arg);
                    }
                });
                toReturn.put("args", stereotypeArguments);
            }
            if (name.equals("extensions")) {
                ArrayList extensionList = new ArrayList((List)value);
                ArrayList stereotypeExtensions = new ArrayList(stereotypeOptions.getOrDefault("extensions", new ArrayList()));
                extensionList.forEach(extension -> {
                    if (!stereotypeExtensions.contains(extension)) {
                        stereotypeExtensions.add(extension);
                    }
                });
                toReturn.put("extensions", stereotypeExtensions);
            }
            if (name.equals("binary") || name.equals("extensions") || name.equals("args")) continue;
            toReturn.put(name, value);
        }
        return toReturn;
    }

    private Map<String, Object> mergeFirefoxOptions(Map<String, Object> stereotypeOptions, Map<String, Object> capsOptions) {
        HashMap<String, Object> toReturn = new HashMap<String, Object>(stereotypeOptions);
        for (Map.Entry<String, Object> entry : capsOptions.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (name.equals("args")) {
                ArrayList arguments = new ArrayList((List)value);
                ArrayList stereotypeArguments = new ArrayList(stereotypeOptions.getOrDefault("args", new ArrayList()));
                arguments.forEach(arg -> {
                    if (!stereotypeArguments.contains(arg)) {
                        stereotypeArguments.add(arg);
                    }
                });
                toReturn.put("args", stereotypeArguments);
            }
            if (name.equals("prefs")) {
                HashMap prefs = new HashMap((Map)value);
                HashMap stereotypePrefs = new HashMap(stereotypeOptions.getOrDefault("prefs", new HashMap()));
                stereotypePrefs.putAll(prefs);
                toReturn.put("prefs", stereotypePrefs);
            }
            if (name.equals("profile")) {
                String rawProfile = (String)value;
                toReturn.put("profile", rawProfile);
            }
            if (!name.equals("log")) continue;
            Map logLevelMap = (Map)value;
            toReturn.put("log", logLevelMap);
        }
        return toReturn;
    }
}

