/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.session.remote;

import java.io.IOException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class ActiveSessionCommandExecutor
implements CommandExecutor {
    private final ActiveSession session;
    private boolean active;

    public ActiveSessionCommandExecutor(ActiveSession session) {
        this.session = (ActiveSession)Require.nonNull((String)"Session", (Object)session);
    }

    public Response execute(Command command) throws IOException {
        if ("newSession".equals(command.getName())) {
            if (this.active) {
                throw new WebDriverException("Cannot start session twice! " + this.session);
            }
            this.active = true;
            Response response = new Response(this.session.getId());
            response.setValue(this.session.getCapabilities());
            return response;
        }
        HttpRequest request = (HttpRequest)this.session.getDownstreamDialect().getCommandCodec().encode(command);
        HttpResponse httpResponse = this.session.execute(request);
        return this.session.getDownstreamDialect().getResponseCodec().decode((Object)httpResponse);
    }
}

