/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;
import org.openqa.selenium.remote.http.WebSocket;

public class ProxyWebsocketsIntoGrid
implements BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> {
    private static final Logger LOG = Logger.getLogger(ProxyWebsocketsIntoGrid.class.getName());
    private final HttpClient.Factory clientFactory;
    private final SessionMap sessions;

    public ProxyWebsocketsIntoGrid(HttpClient.Factory clientFactory, SessionMap sessions) {
        this.clientFactory = Objects.requireNonNull(clientFactory);
        this.sessions = Objects.requireNonNull(sessions);
    }

    @Override
    public Optional<Consumer<Message>> apply(String uri, Consumer<Message> downstream) {
        Objects.requireNonNull(uri);
        Objects.requireNonNull(downstream);
        Optional<SessionId> sessionId = HttpSessionId.getSessionId((String)uri).map(SessionId::new);
        if (!sessionId.isPresent()) {
            return Optional.empty();
        }
        try {
            Session session = this.sessions.get(sessionId.get());
            HttpClient client = this.clientFactory.createClient(ClientConfig.defaultConfig().baseUri(session.getUri()));
            WebSocket upstream = client.openSocket(new HttpRequest(HttpMethod.GET, uri), (WebSocket.Listener)new ForwardingListener(downstream));
            return Optional.of(arg_0 -> ((WebSocket)upstream).send(arg_0));
        }
        catch (NoSuchSessionException e) {
            LOG.info("Attempt to connect to non-existent session: " + uri);
            return Optional.empty();
        }
    }

    private static class ForwardingListener
    implements WebSocket.Listener {
        private final Consumer<Message> downstream;

        public ForwardingListener(Consumer<Message> downstream) {
            this.downstream = Objects.requireNonNull(downstream);
        }

        public void onBinary(byte[] data) {
            this.downstream.accept((Message)new BinaryMessage(data));
        }

        public void onClose(int code, String reason) {
            this.downstream.accept((Message)new CloseMessage(code, reason));
        }

        public void onText(CharSequence data) {
            this.downstream.accept((Message)new TextMessage(data));
        }

        public void onError(Throwable cause) {
            LOG.log(Level.WARNING, "Error proxying websocket command", cause);
        }
    }
}

