/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import java.util.Objects;

public class Device {
    private final String pathOnHost;
    private final String pathInContainer;
    private final String cgroupPermissions;

    private Device(String pathOnHost, String pathInContainer, String cgroupPermissions) {
        this.pathOnHost = pathOnHost;
        this.pathInContainer = pathInContainer;
        this.cgroupPermissions = cgroupPermissions;
    }

    public static Device device(String pathOnHost, String pathInContainer, String cgroupPermissions) {
        if (Objects.isNull(cgroupPermissions) || cgroupPermissions.trim().length() == 0) {
            cgroupPermissions = "crw";
        }
        return new Device(pathOnHost, pathInContainer, cgroupPermissions);
    }

    public String getPathOnHost() {
        return this.pathOnHost;
    }

    public String getPathInContainer() {
        return this.pathInContainer;
    }

    public String getCgroupPermissions() {
        return this.cgroupPermissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return Objects.equals(this.pathOnHost, device.pathOnHost) && Objects.equals(this.pathInContainer, device.pathInContainer) && Objects.equals(this.cgroupPermissions, device.cgroupPermissions);
    }

    public int hashCode() {
        return Objects.hash(this.pathOnHost, this.pathInContainer, this.cgroupPermissions);
    }

    public String toString() {
        return "Device{pathOnHost='" + this.pathOnHost + '\'' + ", pathInContainer='" + this.pathInContainer + '\'' + ", cgroupPermissions='" + this.cgroupPermissions + '\'' + '}';
    }
}

