/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.client.DockerMessages;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

class StartContainer {
    private final HttpHandler client;
    private final String apiVersion;

    public StartContainer(HttpHandler client, String apiVersion) {
        this.client = (HttpHandler)Require.nonNull((String)"HTTP client", (Object)client);
        this.apiVersion = (String)Require.nonNull((String)"API version", (Object)apiVersion);
    }

    public void apply(ContainerId id) {
        Require.nonNull((String)"Container id", (Object)id);
        DockerMessages.throwIfNecessary(this.client.execute((HttpRequest)new HttpRequest(HttpMethod.POST, String.format("/v%s/containers/%s/start", this.apiVersion, id)).addHeader("Content-Type", "text/plain")), "Unable to start container: %s", id);
    }
}

