/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.Beta;
import org.openqa.selenium.docker.Device;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.Port;
import org.openqa.selenium.internal.Require;

@Beta
public class ContainerConfig {
    private static final String DEFAULT_DOCKER_NETWORK = "bridge";
    private static final long DEFAULT_SHM_SIZE = 0x4000000L;
    private final Image image;
    private final Multimap<String, Map<String, Object>> portBindings;
    private final Map<String, String> envVars;
    private final Map<String, String> volumeBinds;
    private final List<Device> devices;
    private final String networkName;
    private final boolean autoRemove;
    private final long shmSize;
    private final Map<String, Object> hostConfig;
    private final Map<String, String> labels;
    private final String name;

    public ContainerConfig(Image image, Multimap<String, Map<String, Object>> portBindings, Map<String, String> envVars, Map<String, String> volumeBinds, List<Device> devices, String networkName, long shmSize) {
        this(image, portBindings, envVars, volumeBinds, devices, networkName, shmSize, (Map<String, Object>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of());
    }

    public ContainerConfig(Image image, Multimap<String, Map<String, Object>> portBindings, Map<String, String> envVars, Map<String, String> volumeBinds, List<Device> devices, String networkName, long shmSize, Map<String, Object> hostConfig) {
        this(image, portBindings, envVars, volumeBinds, devices, networkName, shmSize, hostConfig, (Map<String, String>)ImmutableMap.of());
    }

    public ContainerConfig(Image image, Multimap<String, Map<String, Object>> portBindings, Map<String, String> envVars, Map<String, String> volumeBinds, List<Device> devices, String networkName, long shmSize, Map<String, Object> hostConfig, Map<String, String> labels) {
        this(image, portBindings, envVars, volumeBinds, devices, networkName, shmSize, hostConfig, labels, null);
    }

    public ContainerConfig(Image image, Multimap<String, Map<String, Object>> portBindings, Map<String, String> envVars, Map<String, String> volumeBinds, List<Device> devices, String networkName, long shmSize, Map<String, Object> hostConfig, Map<String, String> labels, String name) {
        this.image = image;
        this.portBindings = portBindings;
        this.envVars = envVars;
        this.volumeBinds = volumeBinds;
        this.devices = devices;
        this.networkName = networkName;
        this.autoRemove = true;
        this.shmSize = shmSize;
        this.hostConfig = hostConfig;
        this.labels = labels;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Image getImage() {
        return this.image;
    }

    public static ContainerConfig image(Image image) {
        return new ContainerConfig(image, (Multimap<String, Map<String, Object>>)HashMultimap.create(), (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), (List<Device>)ImmutableList.of(), DEFAULT_DOCKER_NETWORK, 0x4000000L);
    }

    public ContainerConfig map(Port containerPort, Port hostPort) {
        Require.nonNull((String)"Container port", (Object)containerPort);
        Require.nonNull((String)"Host port", (Object)hostPort);
        if (!hostPort.getProtocol().equals(containerPort.getProtocol())) {
            throw new DockerException(String.format("Port protocols must match: %s -> %s", hostPort, containerPort));
        }
        HashMultimap updatedBindings = HashMultimap.create(this.portBindings);
        updatedBindings.put((Object)(containerPort.getPort() + "/" + containerPort.getProtocol()), (Object)ImmutableMap.of((Object)"HostPort", (Object)String.valueOf(hostPort.getPort()), (Object)"HostIp", (Object)""));
        return new ContainerConfig(this.image, (Multimap<String, Map<String, Object>>)updatedBindings, this.envVars, this.volumeBinds, this.devices, this.networkName, this.shmSize, this.hostConfig, this.labels, this.name);
    }

    public ContainerConfig env(Map<String, String> envVars) {
        Require.nonNull((String)"Container env vars", envVars);
        return new ContainerConfig(this.image, this.portBindings, envVars, this.volumeBinds, this.devices, this.networkName, this.shmSize, this.hostConfig, this.labels, this.name);
    }

    public ContainerConfig bind(Map<String, String> volumeBinds) {
        Require.nonNull((String)"Container volume binds", volumeBinds);
        return new ContainerConfig(this.image, this.portBindings, this.envVars, volumeBinds, this.devices, this.networkName, this.shmSize, this.hostConfig, this.labels, this.name);
    }

    public ContainerConfig network(String networkName) {
        Require.nonNull((String)"Container network name", (Object)networkName);
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, this.devices, networkName, this.shmSize, this.hostConfig, this.labels, this.name);
    }

    public ContainerConfig shmMemorySize(long shmSize) {
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, this.devices, this.networkName, shmSize, this.hostConfig, this.labels, this.name);
    }

    public ContainerConfig devices(List<Device> devices) {
        Require.nonNull((String)"Container device files", devices);
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, devices, this.networkName, this.shmSize, this.hostConfig, this.labels, this.name);
    }

    public ContainerConfig applyHostConfig(Map<String, Object> hostConfig, List<String> configKeys) {
        Map<String, Object> setHostConfig = configKeys.stream().filter(hostConfig::containsKey).filter(key -> hostConfig.get(key) != null).collect(Collectors.toMap(key -> key, hostConfig::get));
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, this.devices, this.networkName, this.shmSize, setHostConfig, this.labels, this.name);
    }

    public ContainerConfig labels(Map<String, String> labels) {
        Require.nonNull((String)"Container labels", labels);
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, this.devices, this.networkName, this.shmSize, this.hostConfig, labels, this.name);
    }

    public ContainerConfig name(String name) {
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, this.devices, this.networkName, this.shmSize, this.hostConfig, this.labels, name);
    }

    public String toString() {
        return "ContainerConfig{image=" + String.valueOf(this.image) + ", portBindings=" + String.valueOf(this.portBindings) + ", envVars=" + String.valueOf(this.envVars) + ", volumeBinds=" + String.valueOf(this.volumeBinds) + ", networkName=" + this.networkName + ", devices=" + String.valueOf(this.devices) + ", autoRemove=" + this.autoRemove + ", shmSize=" + this.shmSize + ", hostConfig=" + String.valueOf(this.hostConfig) + "}";
    }

    private Map<String, Object> toJson() {
        List envVars = this.envVars.keySet().stream().map(key -> String.format("%s=%s", key, this.envVars.get(key))).collect(Collectors.toList());
        List volumeBinds = this.volumeBinds.keySet().stream().map(key -> String.format("%s:%s", key, this.volumeBinds.get(key))).collect(Collectors.toList());
        List devicesMapping = this.devices.stream().map(device -> ImmutableMap.of((Object)"PathOnHost", (Object)device.getPathOnHost(), (Object)"PathInContainer", (Object)device.getPathInContainer(), (Object)"CgroupPermissions", (Object)device.getCgroupPermissions())).collect(Collectors.toList());
        ImmutableMap hostConfig = ImmutableMap.of((Object)"PortBindings", (Object)this.portBindings.asMap(), (Object)"AutoRemove", (Object)this.autoRemove, (Object)"NetworkMode", (Object)this.networkName, (Object)"ShmSize", (Object)this.shmSize, (Object)"Binds", volumeBinds, (Object)"Devices", devicesMapping);
        if (!this.hostConfig.isEmpty()) {
            HashMap<String, Object> copyMap = new HashMap<String, Object>((Map<String, Object>)hostConfig);
            copyMap.putAll(this.hostConfig);
            hostConfig = ImmutableMap.copyOf(copyMap);
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("Image", this.image.getId());
        config.put("Env", envVars);
        config.put("HostConfig", hostConfig);
        if (!this.labels.isEmpty()) {
            config.put("Labels", this.labels);
        }
        return config;
    }
}

