/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import java.time.Duration;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.internal.Require;

public class EventBusOptions {
    static final String EVENTS_SECTION = "events";
    private static final String DEFAULT_CLASS = "org.openqa.selenium.events.zeromq.ZeroMqEventBus";
    private static final int DEFAULT_HEARTBEAT_PERIOD = 60;
    private final Config config;
    private volatile EventBus bus;

    public EventBusOptions(Config config) {
        this.config = (Config)Require.nonNull((String)"Config", (Object)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventBus getEventBus() {
        EventBus localBus = this.bus;
        if (localBus == null) {
            EventBusOptions eventBusOptions = this;
            synchronized (eventBusOptions) {
                localBus = this.bus;
                if (localBus == null) {
                    this.bus = localBus = this.createBus();
                }
            }
        }
        return localBus;
    }

    public Duration getHeartbeatPeriod() {
        int period = this.config.getInt(EVENTS_SECTION, "eventbus-heartbeat-period").orElse(60);
        return Duration.ofSeconds(period);
    }

    private EventBus createBus() {
        return this.config.getClass(EVENTS_SECTION, "implementation", EventBus.class, DEFAULT_CLASS);
    }
}

