/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.SessionRequestCapability;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.graphql.Node;
import org.openqa.selenium.grid.graphql.OsInfo;
import org.openqa.selenium.grid.graphql.Session;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.SessionId;

public class Grid {
    private static final Json JSON = new Json();
    private static final SessionId RESERVED = new SessionId("reserved");
    private final URI uri;
    private final DistributorStatus distributorStatus;
    private final List<Set<Capabilities>> queueInfoList;
    private final String version;

    public Grid(Distributor distributor, NewSessionQueue newSessionQueue, URI uri, String version) {
        Require.nonNull((String)"Distributor", (Object)distributor);
        this.uri = (URI)Require.nonNull((String)"Grid's public URI", (Object)uri);
        NewSessionQueue sessionQueue = (NewSessionQueue)Require.nonNull((String)"New session queue", (Object)newSessionQueue);
        this.queueInfoList = sessionQueue.getQueueContents().stream().map(SessionRequestCapability::getDesiredCapabilities).collect(Collectors.toList());
        this.distributorStatus = distributor.getStatus();
        this.version = (String)Require.nonNull((String)"Grid's version", (Object)version);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Node> getNodes() {
        ImmutableList.Builder toReturn = ImmutableList.builder();
        for (NodeStatus status : this.distributorStatus.getNodes()) {
            HashMap<Capabilities, Integer> stereotypes = new HashMap<Capabilities, Integer>();
            HashMap<org.openqa.selenium.grid.data.Session, Slot> sessions = new HashMap<org.openqa.selenium.grid.data.Session, Slot>();
            for (Slot slot : status.getSlots()) {
                org.openqa.selenium.grid.data.Session session = slot.getSession();
                if (session != null) {
                    sessions.put(session, slot);
                }
                int count = stereotypes.getOrDefault(slot.getStereotype(), 0);
                stereotypes.put(slot.getStereotype(), ++count);
            }
            OsInfo osInfo = new OsInfo(status.getOsInfo().get("arch"), status.getOsInfo().get("name"), status.getOsInfo().get("version"));
            toReturn.add((Object)new Node(status.getNodeId(), status.getExternalUri(), status.getAvailability(), status.getMaxSessionCount(), status.getSessionTimeout(), status.getSlots().size(), stereotypes, sessions, status.getVersion(), osInfo));
        }
        return toReturn.build();
    }

    public int getNodeCount() {
        return this.distributorStatus.getNodes().size();
    }

    public int getSessionCount() {
        return this.distributorStatus.getNodes().stream().map(NodeStatus::getSlots).flatMap(Collection::stream).filter(slot -> slot.getSession() != null).filter(slot -> !slot.getSession().getId().equals((Object)RESERVED)).mapToInt(slot -> 1).sum();
    }

    public int getTotalSlots() {
        return this.distributorStatus.getNodes().stream().mapToInt(status -> status.getSlots().size()).sum();
    }

    public int getMaxSession() {
        return this.distributorStatus.getNodes().stream().mapToInt(NodeStatus::getMaxSessionCount).sum();
    }

    public int getSessionQueueSize() {
        return this.queueInfoList.size();
    }

    public List<String> getSessionQueueRequests() {
        return this.queueInfoList.stream().map(set -> set.isEmpty() ? new ImmutableCapabilities() : (Capabilities)set.iterator().next()).map(arg_0 -> ((Json)JSON).toJson(arg_0)).collect(Collectors.toList());
    }

    public List<Session> getSessions() {
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (NodeStatus status : this.distributorStatus.getNodes()) {
            for (Slot slot : status.getSlots()) {
                if (slot.getSession() == null || slot.getSession().getId().equals((Object)RESERVED)) continue;
                org.openqa.selenium.grid.data.Session session = slot.getSession();
                sessions.add(new Session(session.getId().toString(), session.getCapabilities(), session.getStartTime(), session.getUri(), status.getNodeId().toString(), status.getExternalUri(), slot));
            }
        }
        return sessions;
    }
}

