/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.internal.Console;
import com.beust.jcommander.internal.DefaultConsole;
import com.google.auto.service.AutoService;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.cli.WrappedPrintWriter;
import org.openqa.selenium.grid.commands.InfoFlags;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.server.HelpFlags;

@AutoService(value={CliCommand.class})
public class InfoCommand
implements CliCommand {
    private static final Pattern CODE_OR_LIST_PATTERN = Pattern.compile("^\\s*(\\*|\\d+\\.).*");

    @Override
    public String getName() {
        return "info";
    }

    @Override
    public String getDescription() {
        return "Prints information for commands and topics.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return Collections.singleton(Role.of("info"));
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    public CliCommand.Executable configure(PrintStream out, PrintStream err, String ... args) {
        HelpFlags help = new HelpFlags();
        InfoFlags topic = new InfoFlags();
        JCommander commander = JCommander.newBuilder().programName("selenium").addObject((Object)help).addObject((Object)topic).build();
        commander.setConsole((Console)new DefaultConsole(out));
        return () -> {
            String content;
            String toDisplay;
            String title;
            try {
                commander.parse(args);
            }
            catch (ParameterException e) {
                err.println(e.getMessage());
                commander.usage();
                return;
            }
            if (help.displayHelp(commander, out)) {
                return;
            }
            switch (topic.topic) {
                case "config": {
                    title = "Configuring Selenium";
                    toDisplay = "config.txt";
                    break;
                }
                case "security": {
                    title = "About Security";
                    toDisplay = "security.txt";
                    break;
                }
                case "tracing": {
                    title = "About Tracing";
                    toDisplay = "tracing.txt";
                    break;
                }
                case "sessionmap": {
                    title = "About SessionMaps";
                    toDisplay = "sessionmaps.txt";
                    break;
                }
                default: {
                    title = "Info";
                    toDisplay = "info.txt";
                }
            }
            String path = this.getClass().getPackage().getName().replace('.', '/') + "/" + toDisplay;
            try {
                content = this.readContent(path);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            try (WrappedPrintWriter outWriter = new WrappedPrintWriter((OutputStream)out, 72, 0);){
                outWriter.printf("%n%s%n%s%n%n", title, String.join((CharSequence)"", Collections.nCopies(title.length(), "=")));
                outWriter.print(content);
                outWriter.println("\n\n");
            }
        };
    }

    private String readContent(String path) throws IOException {
        String unformattedText = Resources.toString((URL)Resources.getResource((String)path), (Charset)StandardCharsets.UTF_8);
        StringBuilder formattedText = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new StringReader(unformattedText));){
            boolean inCode = false;
            String line = reader.readLine();
            while (line != null) {
                if (line.isEmpty()) {
                    if (inCode) {
                        formattedText.append("\n");
                    } else {
                        formattedText.append("\n\n");
                    }
                } else if ("```".equals(line)) {
                    inCode = !inCode;
                } else {
                    if (line.charAt(0) == '=') {
                        formattedText.append("\n");
                    }
                    formattedText.append(line);
                    if (inCode || CODE_OR_LIST_PATTERN.matcher(line).matches()) {
                        formattedText.append("\n");
                    } else {
                        formattedText.append(" ");
                    }
                }
                line = reader.readLine();
            }
        }
        return formattedText.toString();
    }
}

