/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Weigher;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.graphql.GridData;
import org.openqa.selenium.grid.graphql.SessionData;
import org.openqa.selenium.grid.graphql.Types;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class GraphqlHandler
implements HttpHandler,
AutoCloseable {
    public static final String GRID_SCHEMA = "/org/openqa/selenium/grid/graphql/selenium-grid-schema.graphqls";
    public static final Json JSON = new Json();
    private static final long MAX_QUERY_SIZE_BYTES = 0x100000L;
    private final Tracer tracer;
    private final Distributor distributor;
    private final NewSessionQueue newSessionQueue;
    private final URI publicUri;
    private final String version;
    private final GraphQL graphQl;
    private final Cache<String, CompletableFuture<PreparsedDocumentEntry>> cache;

    public GraphqlHandler(Tracer tracer, Distributor distributor, NewSessionQueue newSessionQueue, URI publicUri, String version) {
        this.distributor = (Distributor)Require.nonNull((String)"Distributor", (Object)distributor);
        this.newSessionQueue = (NewSessionQueue)Require.nonNull((String)"New session queue", (Object)newSessionQueue);
        this.publicUri = (URI)Require.nonNull((String)"Uri", (Object)publicUri);
        this.version = (String)Require.nonNull((String)"GridVersion", (Object)version);
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        long maxMemory = Runtime.getRuntime().maxMemory();
        long cacheWeightLimit = (long)((double)maxMemory * 0.05);
        QueryCacheWeigher weigher = new QueryCacheWeigher(cacheWeightLimit);
        this.cache = Caffeine.newBuilder().maximumWeight(cacheWeightLimit).weigher((Weigher)weigher).expireAfterAccess(Duration.ofMinutes(30L)).build();
        GraphQLSchema schema = new SchemaGenerator().makeExecutableSchema(this.buildTypeDefinitionRegistry(), this.buildRuntimeWiring());
        this.graphQl = GraphQL.newGraphQL((GraphQLSchema)schema).preparsedDocumentProvider((executionInput, computeFunction) -> {
            String query = executionInput.getQuery();
            if ((long)query.getBytes(StandardCharsets.UTF_8).length > 0x100000L) {
                return CompletableFuture.supplyAsync(() -> (PreparsedDocumentEntry)computeFunction.apply(executionInput));
            }
            return (CompletableFuture)this.cache.get((Object)query, key -> CompletableFuture.supplyAsync(() -> (PreparsedDocumentEntry)computeFunction.apply(executionInput)));
        }).build();
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        if (req.getMethod() == HttpMethod.OPTIONS) {
            return new HttpResponse();
        }
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"grid.status");){
            Map inputs = (Map)JSON.toType(Contents.string((HttpMessage)req), Json.MAP_TYPE);
            AttributeMap attributeMap = this.tracer.createAttributeMap();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), this.getClass().getName());
            Tags.HTTP_REQUEST.accept(span, req);
            Tags.HTTP_REQUEST_EVENT.accept(attributeMap, req);
            if (!(inputs.get("query") instanceof String)) {
                HttpResponse response = (HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.utf8String((CharSequence)"Unable to find query"));
                Tags.HTTP_RESPONSE.accept(span, response);
                Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, response);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), "Unable to find query");
                span.setAttribute(AttributeKey.ERROR.getKey(), true);
                span.setStatus(Status.NOT_FOUND);
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                HttpResponse httpResponse = response;
                return httpResponse;
            }
            String query = (String)inputs.get("query");
            Map variables = inputs.get("variables") instanceof Map ? (Map)inputs.get("variables") : new HashMap();
            ExecutionInput executionInput = ExecutionInput.newExecutionInput((String)query).variables(variables).build();
            ExecutionResult result = this.graphQl.execute(executionInput);
            if (result.isDataPresent()) {
                HttpResponse response = (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.utf8String((CharSequence)JSON.toJson((Object)result.toSpecification())));
                Tags.HTTP_RESPONSE.accept(span, response);
                Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, response);
                span.addEvent("Graphql query executed", attributeMap);
                HttpResponse httpResponse = response;
                return httpResponse;
            }
            HttpResponse response = (HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.utf8String((CharSequence)JSON.toJson((Object)result.getErrors())));
            Tags.HTTP_RESPONSE.accept(span, response);
            Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, response);
            attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), "Error while executing the query");
            span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
            span.setAttribute(AttributeKey.ERROR.getKey(), true);
            span.setStatus(Status.INTERNAL);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }

    @Override
    public void close() {
        this.cache.asMap().values().forEach(future -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    private RuntimeWiring buildRuntimeWiring() {
        GridData gridData = new GridData(this.distributor, this.newSessionQueue, this.publicUri, this.version);
        return RuntimeWiring.newRuntimeWiring().scalar(Types.Uri).scalar(Types.Url).type("GridQuery", typeWiring -> typeWiring.dataFetcher("grid", (DataFetcher)gridData).dataFetcher("sessionsInfo", (DataFetcher)gridData).dataFetcher("nodesInfo", (DataFetcher)gridData).dataFetcher("session", (DataFetcher)new SessionData(this.distributor))).build();
    }

    private TypeDefinitionRegistry buildTypeDefinitionRegistry() {
        TypeDefinitionRegistry typeDefinitionRegistry;
        block8: {
            InputStream stream = this.getClass().getResourceAsStream(GRID_SCHEMA);
            try {
                typeDefinitionRegistry = new SchemaParser().parse(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return typeDefinitionRegistry;
    }

    private static class QueryCacheWeigher
    implements Weigher<String, CompletableFuture<PreparsedDocumentEntry>> {
        private final long maxSingleEntryWeight;

        public QueryCacheWeigher(long cacheWeightLimit) {
            this.maxSingleEntryWeight = (long)((double)cacheWeightLimit * 0.1);
        }

        public int weigh(String key, CompletableFuture<PreparsedDocumentEntry> value) {
            long keyWeight = key.length() * 2;
            long futureOverhead = 200L;
            long documentOverhead = 500L;
            long totalWeight = keyWeight + futureOverhead + documentOverhead;
            long boundedWeight = Math.min(totalWeight, this.maxSingleEntryWeight);
            return (int)Math.min(boundedWeight, Integer.MAX_VALUE);
        }
    }
}

