/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.config;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.openqa.selenium.grid.config.ConfigValue;
import org.openqa.selenium.grid.config.HasRoles;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;

@AutoService(value={HasRoles.class})
public class DistributorFlags
implements HasRoles {
    @Parameter(names={"-d", "--distributor"}, description="Url of the distributor.")
    @ConfigValue(section="distributor", name="host", example={"\"http://localhost:5553\""})
    private URI distributorServer;
    @Parameter(names={"--distributor-port"}, description="Port on which the distributor is listening.")
    @ConfigValue(section="distributor", name="port", example={"5553"})
    private Integer distributorServerPort;
    @Parameter(names={"--distributor-host"}, description="Host on which the distributor is listening.")
    @ConfigValue(section="distributor", name="hostname", example={"\"localhost\""})
    private String distributorServerHost;
    @Parameter(names={"--distributor-implementation"}, description="Full classname of non-default distributor implementation")
    @ConfigValue(section="distributor", name="implementation", example={"org.openqa.selenium.grid.distributor.local.LocalDistributor"})
    private String implementation = "org.openqa.selenium.grid.distributor.local.LocalDistributor";
    @Parameter(names={"--grid-model"}, description="Full classname of non-default grid model. This is used to store states of the all the registered Nodes.")
    @ConfigValue(section="distributor", name="grid-model", example={"org.openqa.selenium.grid.distributor.GridModel"})
    private String gridModel = "org.openqa.selenium.grid.distributor.GridModel";
    @Parameter(names={"--slot-matcher"}, description="Full classname of non-default slot matcher to use. This is used to determine whether a Node can support a particular session.")
    @ConfigValue(section="distributor", name="slot-matcher", example={"org.openqa.selenium.grid.data.DefaultSlotMatcher"})
    private String slotMatcher = "org.openqa.selenium.grid.data.DefaultSlotMatcher";
    @Parameter(names={"--slot-selector"}, description="Full classname of non-default slot selector. This is used to select a slot in a Node once the Node has been matched.")
    @ConfigValue(section="distributor", name="slot-selector", example={"org.openqa.selenium.grid.distributor.selector.DefaultSlotSelector"})
    private String slotSelector = "org.openqa.selenium.grid.distributor.selector.DefaultSlotSelector";
    @Parameter(names={"--healthcheck-interval"}, description="How often, in seconds, will the health check run for all Nodes.This ensures the server can ping all the Nodes successfully.")
    @ConfigValue(section="distributor", name="healthcheck-interval", example={"60"})
    public int healthcheckInterval = 120;
    @Parameter(description="Allow the Distributor to reject a request immediately if the Grid does not support the requested capability.Rejecting requests immediately is suitable for Grid set up that does not spin up Nodes on demand.", names={"--reject-unsupported-caps"}, arity=1)
    @ConfigValue(section="distributor", name="reject-unsupported-caps", example={"true"})
    private boolean rejectUnsupportedCaps = false;

    public Set<Role> getRoles() {
        return Collections.singleton(StandardGridRoles.DISTRIBUTOR_ROLE);
    }
}

