/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.internal.Console;
import com.beust.jcommander.internal.DefaultConsole;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.grid.config.AnnotatedConfig;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.ConcatenatingConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigFlags;
import org.openqa.selenium.grid.config.EnvConfig;
import org.openqa.selenium.grid.config.HasRoles;
import org.openqa.selenium.grid.config.MemoizedConfig;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.HelpFlags;

public abstract class TemplateGridCommand
implements CliCommand {
    @Override
    public final CliCommand.Executable configure(PrintStream out, PrintStream err, String ... args) {
        HelpFlags helpFlags = new HelpFlags();
        ConfigFlags configFlags = new ConfigFlags();
        LinkedHashSet<Object> allFlags = new LinkedHashSet<Object>();
        allFlags.add(helpFlags);
        allFlags.add(configFlags);
        StreamSupport.stream(ServiceLoader.load(HasRoles.class).spliterator(), false).filter(flags -> !Sets.intersection(this.getConfigurableRoles(), flags.getRoles()).isEmpty()).forEach(allFlags::add);
        JCommander.Builder builder = JCommander.newBuilder().programName(this.getName());
        allFlags.forEach(arg_0 -> ((JCommander.Builder)builder).addObject(arg_0));
        JCommander commander = builder.build();
        commander.setConsole((Console)new DefaultConsole(out));
        return () -> {
            try {
                commander.parse(args);
            }
            catch (ParameterException e) {
                err.println(e.getMessage());
                commander.usage();
                return;
            }
            if (helpFlags.displayHelp(commander, out)) {
                return;
            }
            LinkedHashSet<Config> allConfigs = new LinkedHashSet<Config>();
            allConfigs.add(new EnvConfig());
            allConfigs.add(new ConcatenatingConfig(this.getSystemPropertiesConfigPrefix(), '.', System.getProperties()));
            Set cliArgs = commander.getFields().values().stream().filter(ParameterDescription::isAssigned).map(ParameterDescription::getLongestName).collect(Collectors.toSet());
            if (!cliArgs.isEmpty()) {
                allFlags.forEach(flags -> allConfigs.add(new AnnotatedConfig(flags, cliArgs, true)));
            }
            allConfigs.add(configFlags.readConfigFiles());
            allConfigs.add(this.getDefaultConfig());
            this.getFlagObjects().forEach(flagObject -> allConfigs.add(new AnnotatedConfig(flagObject)));
            allFlags.forEach(flags -> allConfigs.add(new AnnotatedConfig(flags, cliArgs, false)));
            MemoizedConfig config = new MemoizedConfig(new CompoundConfig(allConfigs.toArray(new Config[0])));
            if (configFlags.dumpConfig(config, out)) {
                return;
            }
            if (configFlags.dumpConfigHelp(config, this.getConfigurableRoles(), out)) {
                return;
            }
            LoggingOptions loggingOptions = new LoggingOptions(config);
            loggingOptions.configureLogging();
            this.execute(config);
        };
    }

    protected abstract String getSystemPropertiesConfigPrefix();

    protected abstract Config getDefaultConfig();

    protected abstract void execute(Config var1);
}

