/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.docker.Container;
import org.openqa.selenium.docker.ContainerConfig;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.DockerProtocol;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.VersionCommand;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpHandler;

public class Docker {
    private static final Logger LOG = Logger.getLogger(Docker.class.getName());
    protected final HttpHandler client;
    private volatile Optional<DockerProtocol> dockerClient;

    public Docker(HttpHandler client) {
        this.client = (HttpHandler)Require.nonNull((String)"HTTP client", (Object)client);
        this.dockerClient = Optional.empty();
    }

    public boolean isSupported() {
        return this.getDocker().isPresent();
    }

    public String getVersion() {
        return this.getDocker().map(DockerProtocol::version).orElse("unsupported");
    }

    public Image getImage(String name) {
        Require.nonNull((String)"Image name to get", (Object)name);
        LOG.info("Obtaining image: " + name);
        return this.getDocker().map(protocol -> protocol.getImage(name)).orElseThrow(() -> new DockerException("Unable to get image " + name));
    }

    public Container create(ContainerConfig config) {
        Require.nonNull((String)"Container config", (Object)config);
        LOG.fine("Creating image from " + String.valueOf(config));
        return this.getDocker().map(protocol -> protocol.create(config)).orElseThrow(() -> new DockerException("Unable to create container: " + String.valueOf(config)));
    }

    public Optional<ContainerInfo> inspect(ContainerId id) {
        Require.nonNull((String)"Container id", (Object)id);
        LOG.fine("Inspecting container with id: " + String.valueOf(id));
        if (!this.getDocker().map(protocol -> protocol.isContainerPresent(id)).orElse(false).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(this.getDocker().map(protocol -> protocol.inspectContainer(id)).orElseThrow(() -> new DockerException("Unable to inspect container: " + String.valueOf(id))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<DockerProtocol> getDocker() {
        if (this.dockerClient.isPresent()) {
            return this.dockerClient;
        }
        Docker docker = this;
        synchronized (docker) {
            if (!this.dockerClient.isPresent()) {
                this.dockerClient = new VersionCommand(this.client).getDockerProtocol();
            }
        }
        return this.dockerClient;
    }
}

