/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import org.openqa.selenium.grid.web.JarFileResource;
import org.openqa.selenium.grid.web.Resource;
import org.openqa.selenium.internal.Require;

public class ClassPathResource
implements Resource {
    private final Resource delegate;

    public ClassPathResource(URL resourceUrl, String stripPrefix) {
        Require.nonNull((String)"Resource URL", (Object)resourceUrl);
        Require.nonNull((String)"Prefix to strip", (Object)stripPrefix);
        if ("jar".equals(resourceUrl.getProtocol())) {
            try {
                JarURLConnection juc = (JarURLConnection)resourceUrl.openConnection();
                JarFile jarFile = juc.getJarFile();
                this.delegate = new JarFileResource(jarFile, juc.getEntryName(), stripPrefix);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            throw new IllegalArgumentException("Unable to handle scheme of type " + resourceUrl.getProtocol());
        }
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public Optional<Resource> get(String path) {
        Require.nonNull((String)"Path", (Object)path);
        return this.delegate.get(path);
    }

    @Override
    public boolean isDirectory() {
        return this.delegate.isDirectory();
    }

    @Override
    public Set<Resource> list() {
        return this.delegate.list();
    }

    @Override
    public Optional<byte[]> read() {
        return this.delegate.read();
    }
}

