/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.internal.Require;

public class MapConfig
implements Config {
    private final Map<String, Map<String, Object>> raw;

    public MapConfig(Map<String, Object> raw) {
        Require.nonNull((String)"Underlying map", raw);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, Object> entry : raw.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            ImmutableMap values = (ImmutableMap)((Map)entry.getValue()).entrySet().stream().filter(e -> e.getKey() instanceof String).collect(ImmutableMap.toImmutableMap(e -> String.valueOf(e.getKey()), Map.Entry::getValue));
            builder.put((Object)entry.getKey(), (Object)values);
        }
        this.raw = builder.build();
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull((String)"Section name", (Object)section);
        Require.nonNull((String)"Option name", (Object)option);
        Map<String, Object> rawSection = this.raw.get(section);
        if (rawSection == null) {
            return Optional.empty();
        }
        Object value = rawSection.get(option);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.stream().anyMatch(item -> item instanceof Map)) {
                return Optional.of((List)collection.stream().map(item -> (Map)item).map(this::toEntryList).flatMap(Collection::stream).collect(ImmutableList.toImmutableList()));
            }
            return Optional.of((List)collection.stream().filter(item -> !(item instanceof Collection)).map(String::valueOf).collect(ImmutableList.toImmutableList()));
        }
        if (value instanceof Map) {
            return Optional.of(this.toEntryList((Map)value));
        }
        return Optional.of(ImmutableList.of((Object)String.valueOf(value)));
    }

    @Override
    public Set<String> getSectionNames() {
        return ImmutableSet.copyOf(this.raw.keySet());
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull((String)"Section name to get options for", (Object)section);
        Map<String, Object> values = this.raw.getOrDefault(section, (Map<String, Object>)ImmutableMap.of());
        return ImmutableSortedSet.copyOf(values.keySet());
    }
}

