/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.TextMessage;

class MessageInboundConverter
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger LOG = Logger.getLogger(MessageInboundConverter.class.getName());
    private Continuation next = Continuation.None;
    private StringBuilder builder;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public MessageInboundConverter() {
        this.builder = new StringBuilder();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) {
        TextMessage message;
        block23: {
            boolean finalFragment;
            block22: {
                finalFragment = frame.isFinalFragment();
                if (!(frame instanceof ContinuationWebSocketFrame)) break block22;
                switch (this.next) {
                    case Binary: {
                        try {
                            ByteBuf content = frame.content();
                            content.readBytes((OutputStream)this.buffer, content.readableBytes());
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException("failed to transfer buffer", e);
                        }
                        if (!finalFragment) return;
                        message = new BinaryMessage(this.buffer.toByteArray());
                        this.buffer.reset();
                        this.next = Continuation.None;
                        break block23;
                    }
                    case Text: {
                        this.builder.append(((ContinuationWebSocketFrame)frame).text());
                        if (!finalFragment) return;
                        message = new TextMessage((CharSequence)this.builder.toString());
                        this.builder.setLength(0);
                        this.next = Continuation.None;
                        break block23;
                    }
                    case None: {
                        ctx.write((Object)frame);
                        return;
                    }
                    default: {
                        throw new IllegalStateException("unexpected enum: " + this.next);
                    }
                }
            }
            if (this.next != Continuation.None) {
                throw new IllegalStateException("expected a continuation frame");
            }
            if (frame instanceof TextWebSocketFrame) {
                if (finalFragment) {
                    message = new TextMessage((CharSequence)((TextWebSocketFrame)frame).text());
                } else {
                    this.next = Continuation.Text;
                    message = null;
                    this.builder.append(((TextWebSocketFrame)frame).text());
                }
            } else if (frame instanceof BinaryWebSocketFrame) {
                ByteBuf content = frame.content();
                if (finalFragment) {
                    if (content.nioBufferCount() != -1) {
                        message = new BinaryMessage(content.nioBuffer());
                    } else {
                        if (!content.hasArray()) throw new IllegalStateException("Unable to handle bytebuf: " + content);
                        message = new BinaryMessage(ByteBuffer.wrap(content.array()));
                    }
                } else {
                    this.next = Continuation.Binary;
                    message = null;
                    try {
                        content.readBytes((OutputStream)this.buffer, content.readableBytes());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("failed to transfer buffer", e);
                    }
                }
            } else if (frame instanceof CloseWebSocketFrame) {
                CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
                message = new CloseMessage(closeFrame.statusCode(), closeFrame.reasonText());
            } else {
                ctx.write((Object)frame);
                return;
            }
        }
        if (message == null) return;
        ctx.fireChannelRead((Object)message);
    }

    private static enum Continuation {
        Text,
        Binary,
        None;

    }
}

