/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.io.Reader;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;

public class SessionRequest {
    private static final Type SET_OF_CAPABILITIES = new TypeToken<Set<Capabilities>>(){}.getType();
    private static final Type SET_OF_DIALECTS = new TypeToken<Set<Dialect>>(){}.getType();
    private static final Type TRACE_HEADERS = new TypeToken<Map<String, String>>(){}.getType();
    private final RequestId requestId;
    private final Instant enqueued;
    private final Set<Capabilities> desiredCapabilities;
    private final Set<Dialect> downstreamDialects;
    private final Map<String, Object> metadata;
    private final Map<String, String> traceHeaders;

    public SessionRequest(RequestId requestId, HttpRequest request, Instant enqueued) {
        this.requestId = (RequestId)Require.nonNull((String)"Request ID", (Object)requestId);
        this.enqueued = (Instant)Require.nonNull((String)"Enqueued time", (Object)enqueued);
        Require.nonNull((String)"Request", (Object)request);
        try (NewSessionPayload payload = NewSessionPayload.create((Reader)Contents.reader((HttpMessage)request));){
            this.desiredCapabilities = payload.stream().filter(capabilities -> !capabilities.asMap().isEmpty()).collect(Collectors.toSet());
            this.downstreamDialects = payload.getDownstreamDialects();
            this.metadata = payload.getMetadata();
        }
        HashMap headers = new HashMap();
        Optional<String> traceParentValue = Optional.ofNullable(request.getHeader("traceparent"));
        traceParentValue.ifPresent(value -> headers.put("traceparent", value));
        this.traceHeaders = Collections.unmodifiableMap(headers);
    }

    public SessionRequest(RequestId requestId, Instant enqueued, Set<Dialect> downstreamDialects, Set<Capabilities> desiredCapabilities, Map<String, Object> metadata, Map<String, String> traceHeaders) {
        this.requestId = (RequestId)Require.nonNull((String)"Request ID", (Object)requestId);
        this.enqueued = (Instant)Require.nonNull((String)"Enqueued time", (Object)enqueued);
        this.downstreamDialects = Collections.unmodifiableSet(new HashSet((Collection)Require.nonNull((String)"Downstream dialects", downstreamDialects)));
        this.desiredCapabilities = Collections.unmodifiableSet(new LinkedHashSet((Collection)Require.nonNull((String)"Capabilities", desiredCapabilities)));
        this.metadata = Collections.unmodifiableMap(new TreeMap((Map)Require.nonNull((String)"Metadata", metadata)));
        this.traceHeaders = Collections.unmodifiableMap(new HashMap((Map)Require.nonNull((String)"Trace HTTP headers", traceHeaders)));
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Map<String, String> getTraceHeaders() {
        return this.traceHeaders;
    }

    public String getTraceHeader(String key) {
        return this.traceHeaders.get(key);
    }

    public Set<Capabilities> getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public Set<Dialect> getDownstreamDialects() {
        return this.downstreamDialects;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Instant getEnqueued() {
        return this.enqueued;
    }

    public String toString() {
        return new StringJoiner(", ", SessionRequest.class.getSimpleName() + "[", "]").add("requestId=" + this.requestId).add("desiredCapabilities=" + this.desiredCapabilities).add("downstreamDialects=" + this.downstreamDialects).add("metadata=" + this.metadata).add("traceHeaders=" + this.traceHeaders).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SessionRequest)) {
            return false;
        }
        SessionRequest that = (SessionRequest)o;
        return this.requestId.equals(that.requestId) && this.desiredCapabilities.equals(that.desiredCapabilities) && this.downstreamDialects.equals(that.downstreamDialects) && this.metadata.equals(that.metadata) && this.traceHeaders.equals(that.traceHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.enqueued, this.desiredCapabilities, this.downstreamDialects, this.metadata, this.traceHeaders);
    }

    private Map<String, Object> toJson() {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put("requestId", this.requestId);
        toReturn.put("enqueued", this.enqueued);
        toReturn.put("dialects", this.downstreamDialects);
        toReturn.put("capabilities", this.desiredCapabilities);
        toReturn.put("metadata", this.metadata);
        toReturn.put("traceHeaders", this.traceHeaders);
        return Collections.unmodifiableMap(toReturn);
    }

    private static SessionRequest fromJson(JsonInput input) {
        RequestId id = null;
        Instant enqueued = null;
        Set capabilities = null;
        Set dialects = null;
        Map metadata = Collections.emptyMap();
        Map tracerHeaders = Collections.emptyMap();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "capabilities": {
                    capabilities = (Set)input.read(SET_OF_CAPABILITIES);
                    continue block16;
                }
                case "dialects": {
                    dialects = (Set)input.read(SET_OF_DIALECTS);
                    continue block16;
                }
                case "enqueued": {
                    enqueued = (Instant)input.read(Instant.class);
                    continue block16;
                }
                case "metadata": {
                    metadata = (Map)input.read(Json.MAP_TYPE);
                    continue block16;
                }
                case "requestId": {
                    id = (RequestId)input.read(RequestId.class);
                    continue block16;
                }
                case "traceHeaders": {
                    tracerHeaders = (Map)input.read(TRACE_HEADERS);
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SessionRequest(id, enqueued, dialects, capabilities, metadata, tracerHeaders);
    }
}

