/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class GridStatusHandler
implements HttpHandler {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r, "Grid status executor");
        thread.setDaemon(true);
        return thread;
    });
    private final Tracer tracer;
    private final Distributor distributor;

    GridStatusHandler(Tracer tracer, Distributor distributor) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.distributor = (Distributor)Require.nonNull((String)"Distributor", (Object)distributor);
    }

    /*
     * Loose catch block
     */
    public HttpResponse execute(HttpRequest req) {
        Throwable throwable2222;
        Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"grid.status");
        try {
            DistributorStatus status;
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            Tags.HTTP_REQUEST.accept(span, req);
            Tags.HTTP_REQUEST_EVENT.accept(attributeMap, req);
            try {
                status = (DistributorStatus)EXECUTOR_SERVICE.submit(span.wrap(this.distributor::getStatus)).get(2L, TimeUnit.SECONDS);
            }
            catch (ExecutionException | TimeoutException e) {
                span.setAttribute("error", true);
                span.setStatus(Status.CANCELLED);
                Tags.EXCEPTION.accept(attributeMap, e);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Error or timeout while getting Distributor status: " + e.getMessage())));
                HttpResponse response = (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"ready", (Object)false, (Object)"message", (Object)"Unable to read distributor status."))));
                Tags.HTTP_RESPONSE.accept(span, response);
                Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, response);
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                HttpResponse httpResponse = response;
                if (span != null) {
                    span.close();
                }
                return httpResponse;
            }
            catch (InterruptedException e) {
                HttpResponse httpResponse;
                block12: {
                    span.setAttribute("error", true);
                    span.setStatus(Status.ABORTED);
                    Tags.EXCEPTION.accept(attributeMap, e);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Interruption while getting distributor status: " + e.getMessage())));
                    HttpResponse response = (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"ready", (Object)false, (Object)"message", (Object)"Reading distributor status was interrupted."))));
                    Tags.HTTP_RESPONSE.accept(span, response);
                    Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, response);
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    Thread.currentThread().interrupt();
                    httpResponse = response;
                    if (span == null) break block12;
                    span.close();
                }
                return httpResponse;
            }
            boolean ready = status.getNodes().stream().anyMatch(nodeStatus -> Availability.UP.equals((Object)nodeStatus.getAvailability()));
            List nodeResults = status.getNodes().stream().map(node -> new ImmutableMap.Builder().put((Object)"id", (Object)node.getNodeId()).put((Object)"uri", (Object)node.getExternalUri()).put((Object)"maxSessions", (Object)node.getMaxSessionCount()).put((Object)"osInfo", node.getOsInfo()).put((Object)"heartbeatPeriod", (Object)node.getHeartbeatPeriod().toMillis()).put((Object)"availability", (Object)node.getAvailability()).put((Object)"version", (Object)node.getVersion()).put((Object)"slots", node.getSlots()).build()).collect(Collectors.toList());
            ImmutableMap.Builder value = ImmutableMap.builder();
            value.put((Object)"ready", (Object)ready);
            value.put((Object)"message", (Object)(ready ? "Selenium Grid ready." : "Selenium Grid not ready."));
            value.put((Object)"nodes", nodeResults);
            HttpResponse res = (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)value.build())));
            Tags.HTTP_RESPONSE.accept(span, res);
            Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, res);
            attributeMap.put("grid.status", EventAttribute.setValue((boolean)ready));
            span.setStatus(Status.OK);
            span.addEvent("Computed grid status", attributeMap);
            HttpResponse httpResponse = res;
            return httpResponse;
            {
                catch (Throwable throwable2222) {
                    throw throwable2222;
                }
            }
        }
        finally {
            if (span != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable3) {
                    throwable2222.addSuppressed(throwable3);
                }
            }
        }
    }
}

