/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.concurrent.ExecutorServices;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NewSessionErrorResponse;
import org.openqa.selenium.grid.data.NewSessionRejectedEvent;
import org.openqa.selenium.grid.data.NewSessionRequestEvent;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.data.SessionRequest;
import org.openqa.selenium.grid.data.SessionRequestCapability;
import org.openqa.selenium.grid.data.SlotMatcher;
import org.openqa.selenium.grid.data.TraceSessionRequest;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.jmx.JMXHelper;
import org.openqa.selenium.grid.jmx.ManagedAttribute;
import org.openqa.selenium.grid.jmx.ManagedService;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;

@ManagedService(objectName="org.seleniumhq.grid:type=SessionQueue,name=LocalSessionQueue", description="New session queue")
public class LocalNewSessionQueue
extends NewSessionQueue
implements Closeable {
    private static final String NAME = "Local New Session Queue";
    private final EventBus bus;
    private final SlotMatcher slotMatcher;
    private final Duration requestTimeout;
    private final Map<RequestId, Data> requests;
    private final Map<RequestId, TraceContext> contexts;
    private final Deque<SessionRequest> queue;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName(NAME);
        return thread;
    });

    public LocalNewSessionQueue(Tracer tracer, EventBus bus, SlotMatcher slotMatcher, Duration retryPeriod, Duration requestTimeout, Secret registrationSecret) {
        super(tracer, registrationSecret);
        this.slotMatcher = (SlotMatcher)Require.nonNull((String)"Slot matcher", (Object)slotMatcher);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        Require.nonNull((String)"Retry period", (Object)retryPeriod);
        if (retryPeriod.isNegative() || retryPeriod.isZero()) {
            throw new IllegalArgumentException("Retry period must be positive");
        }
        this.requestTimeout = (Duration)Require.nonNull((String)"Request timeout", (Object)requestTimeout);
        if (requestTimeout.isNegative() || requestTimeout.isZero()) {
            throw new IllegalArgumentException("Request timeout must be positive");
        }
        this.requests = new ConcurrentHashMap<RequestId, Data>();
        this.queue = new ConcurrentLinkedDeque<SessionRequest>();
        this.contexts = new ConcurrentHashMap<RequestId, TraceContext>();
        this.service.scheduleAtFixedRate(this::timeoutSessions, retryPeriod.toMillis(), retryPeriod.toMillis(), TimeUnit.MILLISECONDS);
        new JMXHelper().register(this);
    }

    public static NewSessionQueue create(Config config) {
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        EventBusOptions eventBusOptions = new EventBusOptions(config);
        NewSessionQueueOptions newSessionQueueOptions = new NewSessionQueueOptions(config);
        SecretOptions secretOptions = new SecretOptions(config);
        SlotMatcher slotMatcher = new DistributorOptions(config).getSlotMatcher();
        return new LocalNewSessionQueue(tracer, eventBusOptions.getEventBus(), slotMatcher, newSessionQueueOptions.getSessionRequestRetryInterval(), newSessionQueueOptions.getSessionRequestTimeout(), secretOptions.getRegistrationSecret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutSessions() {
        Set ids;
        Instant now = Instant.now();
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            ids = this.requests.entrySet().stream().filter(entry -> this.isTimedOut(now, (Data)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = this.lock.writeLock();
        try {
            for (RequestId id : ids) {
                this.failDueToTimeout(id);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private boolean isTimedOut(Instant now, Data data) {
        return data.endTime.isBefore(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse addToQueue(SessionRequest request) {
        Require.nonNull((String)"New session request", (Object)request);
        Require.nonNull((String)"Request id", (Object)request.getRequestId());
        TraceContext context = TraceSessionRequest.extract(this.tracer, request);
        try (Span span = context.createSpan("sessionqueue.add_to_queue");){
            Either result;
            this.contexts.put(request.getRequestId(), context);
            Data data = this.injectIntoQueue(request);
            if (this.isTimedOut(Instant.now(), data)) {
                this.failDueToTimeout(request.getRequestId());
            }
            try {
                result = data.latch.await(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS) ? data.result : Either.left((Object)((Object)new SessionNotCreatedException("New session request timed out")));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                result = Either.left((Object)((Object)new SessionNotCreatedException("Interrupted when creating the session", (Throwable)e)));
            }
            catch (RuntimeException e) {
                result = Either.left((Object)((Object)new SessionNotCreatedException("An error occurred creating the session", (Throwable)e)));
            }
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                this.requests.remove(request.getRequestId());
                this.queue.remove(request);
            }
            finally {
                writeLock.unlock();
            }
            HttpResponse res = new HttpResponse();
            if (result.isRight()) {
                res.setContent(Contents.bytes((byte[])((CreateSessionResponse)result.right()).getDownstreamEncodedResponse()));
            } else {
                res.setStatus(500).setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"error", (Object)"session not created", (Object)"message", (Object)((SessionNotCreatedException)((Object)result.left())).getMessage(), (Object)"stacktrace", (Object)((SessionNotCreatedException)((Object)result.left())).getStackTrace()))));
            }
            HttpResponse httpResponse = res;
            return httpResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Data injectIntoQueue(SessionRequest request) {
        Require.nonNull((String)"Session request", (Object)request);
        Data data = new Data(request.getEnqueued());
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.requests.put(request.getRequestId(), data);
            this.queue.addLast(request);
        }
        finally {
            writeLock.unlock();
        }
        this.bus.fire(new NewSessionRequestEvent(request.getRequestId()));
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retryAddToQueue(SessionRequest request) {
        Require.nonNull((String)"New session request", (Object)request);
        TraceContext context = this.contexts.getOrDefault(request.getRequestId(), this.tracer.getCurrentContext());
        try (Span span = context.createSpan("sessionqueue.retry");){
            boolean added;
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                if (!this.requests.containsKey(request.getRequestId())) {
                    boolean bl = false;
                    return bl;
                }
                if (this.queue.contains(request)) {
                    boolean bl = true;
                    return bl;
                }
                added = this.queue.offerFirst(request);
            }
            finally {
                writeLock.unlock();
            }
            if (added) {
                this.bus.fire(new NewSessionRequestEvent(request.getRequestId()));
            }
            boolean bl = added;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<SessionRequest> remove(RequestId reqId) {
        Require.nonNull((String)"Request ID", (Object)reqId);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            Iterator<SessionRequest> iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                SessionRequest req = iterator.next();
                if (!reqId.equals(req.getRequestId())) continue;
                iterator.remove();
                Optional<SessionRequest> optional = Optional.of(req);
                return optional;
            }
            Optional<SessionRequest> optional = Optional.empty();
            return optional;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<SessionRequest> getNextAvailable(Set<Capabilities> stereotypes) {
        Require.nonNull((String)"Stereotypes", stereotypes);
        Predicate<Capabilities> matchesStereotype = caps -> stereotypes.stream().anyMatch(stereotype -> this.slotMatcher.matches((Capabilities)stereotype, (Capabilities)caps));
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            Optional<SessionRequest> maybeRequest = this.queue.stream().filter(req -> req.getDesiredCapabilities().stream().anyMatch(matchesStereotype)).findFirst();
            maybeRequest.ifPresent(req -> this.remove(req.getRequestId()));
            Optional<SessionRequest> optional = maybeRequest;
            return optional;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(RequestId reqId, Either<SessionNotCreatedException, CreateSessionResponse> result) {
        Require.nonNull((String)"New session request", (Object)reqId);
        Require.nonNull((String)"Result", result);
        TraceContext context = this.contexts.getOrDefault(reqId, this.tracer.getCurrentContext());
        try (Span span = context.createSpan("sessionqueue.completed");){
            Data data;
            Lock readLock = this.lock.readLock();
            readLock.lock();
            try {
                data = this.requests.get(reqId);
            }
            finally {
                readLock.unlock();
            }
            if (data == null) {
                return;
            }
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                this.requests.remove(reqId);
                this.queue.removeIf(req -> reqId.equals(req.getRequestId()));
                this.contexts.remove(reqId);
            }
            finally {
                writeLock.unlock();
            }
            if (result.isLeft()) {
                this.bus.fire(new NewSessionRejectedEvent(new NewSessionErrorResponse(reqId, ((SessionNotCreatedException)((Object)result.left())).getMessage())));
            }
            data.setResult(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clearQueue() {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            int size = this.queue.size();
            this.queue.clear();
            this.requests.forEach((reqId, data) -> {
                data.setResult((Either<SessionNotCreatedException, CreateSessionResponse>)Either.left((Object)((Object)new SessionNotCreatedException("Request queue was cleared"))));
                this.bus.fire(new NewSessionRejectedEvent(new NewSessionErrorResponse((RequestId)reqId, "New session queue was forcibly cleared")));
            });
            this.requests.clear();
            int n = size;
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public List<SessionRequestCapability> getQueueContents() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List<SessionRequestCapability> list = this.queue.stream().map(req -> new SessionRequestCapability(req.getRequestId(), req.getDesiredCapabilities())).collect(Collectors.toList());
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    @ManagedAttribute(name="NewSessionQueueSize")
    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void close() throws IOException {
        ExecutorServices.shutdownGracefully((String)NAME, (ExecutorService)this.service);
    }

    private void failDueToTimeout(RequestId reqId) {
        this.complete(reqId, (Either<SessionNotCreatedException, CreateSessionResponse>)Either.left((Object)((Object)new SessionNotCreatedException("Timed out creating session"))));
    }

    private class Data {
        public final Instant endTime;
        public Either<SessionNotCreatedException, CreateSessionResponse> result;
        private boolean complete;
        private final CountDownLatch latch = new CountDownLatch(1);

        public Data(Instant enqueued) {
            this.endTime = enqueued.plus(LocalNewSessionQueue.this.requestTimeout);
            this.result = Either.left((Object)((Object)new SessionNotCreatedException("Session not created")));
        }

        public synchronized void setResult(Either<SessionNotCreatedException, CreateSessionResponse> result) {
            if (this.complete) {
                return;
            }
            this.result = result;
            this.complete = true;
            this.latch.countDown();
        }
    }
}

