/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;

public class NewSessionQueueOptions {
    static final String SESSION_QUEUE_SECTION = "sessionqueue";
    private final Config config;

    public NewSessionQueueOptions(Config config) {
        this.config = config;
    }

    public URI getSessionQueueUri() {
        Optional<URI> host = this.config.get(SESSION_QUEUE_SECTION, "host").map(str -> {
            try {
                URI sessionQueueUri = new URI((String)str);
                if (sessionQueueUri.getHost() == null || sessionQueueUri.getPort() == -1) {
                    throw new ConfigException("Undefined host or port in SessionQueue server URI: " + str, new Object[0]);
                }
                return sessionQueueUri;
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Session queue server URI is not a valid URI: " + str, new Object[0]);
            }
        });
        if (host.isPresent()) {
            return host.get();
        }
        Optional port = this.config.getInt(SESSION_QUEUE_SECTION, "port");
        Optional hostname = this.config.get(SESSION_QUEUE_SECTION, "hostname");
        if (!port.isPresent() || !hostname.isPresent()) {
            throw new ConfigException("Unable to determine host and port for the session queue server", new Object[0]);
        }
        try {
            return new URI("http", null, (String)hostname.get(), (Integer)port.get(), "", null, null);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Session queue server uri configured through host (%s) and port (%d) is not a valid URI", new Object[]{hostname.get(), port.get()});
        }
    }

    public NewSessionQueue getSessionQueue(String implementation) {
        return (NewSessionQueue)this.config.getClass(SESSION_QUEUE_SECTION, "implementation", NewSessionQueue.class, implementation);
    }
}

