/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.TemplateGridServerCommand;
import org.openqa.selenium.grid.commands.DefaultHubConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.distributor.local.LocalDistributor;
import org.openqa.selenium.grid.graphql.GraphqlHandler;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.router.ProxyCdpIntoGrid;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.grid.sessionmap.local.LocalSessionMap;
import org.openqa.selenium.grid.sessionqueue.config.SessionRequestOptions;
import org.openqa.selenium.grid.sessionqueue.local.LocalNewSessionQueue;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.grid.web.GridUiRoute;
import org.openqa.selenium.grid.web.RoutableHttpClientFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;

@AutoService(value={CliCommand.class})
public class Hub
extends TemplateGridServerCommand {
    private static final Logger LOG = Logger.getLogger(Hub.class.getName());

    @Override
    public String getName() {
        return "hub";
    }

    @Override
    public String getDescription() {
        return "A grid hub, composed of sessions, distributor, and router.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.DISTRIBUTOR_ROLE, (Object)StandardGridRoles.EVENT_BUS_ROLE, (Object)StandardGridRoles.HTTPD_ROLE, (Object)StandardGridRoles.SESSION_QUEUE_ROLE, (Object)StandardGridRoles.ROUTER_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "selenium";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultHubConfig();
    }

    @Override
    protected TemplateGridServerCommand.Handlers createHandlers(Config config) {
        URL externalUrl;
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        EventBusOptions events = new EventBusOptions(config);
        EventBus bus = events.getEventBus();
        CombinedHandler handler = new CombinedHandler();
        LocalSessionMap sessions = new LocalSessionMap(tracer, bus);
        handler.addHandler(sessions);
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        SecretOptions secretOptions = new SecretOptions(config);
        Secret secret = secretOptions.getRegistrationSecret();
        try {
            externalUrl = serverOptions.getExternalUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        NetworkOptions networkOptions = new NetworkOptions(config);
        RoutableHttpClientFactory clientFactory = new RoutableHttpClientFactory(externalUrl, handler, networkOptions.getHttpClientFactory(tracer));
        DistributorOptions distributorOptions = new DistributorOptions(config);
        SessionRequestOptions sessionRequestOptions = new SessionRequestOptions(config);
        LocalNewSessionQueue queue = new LocalNewSessionQueue(tracer, bus, distributorOptions.getSlotMatcher(), sessionRequestOptions.getSessionRequestRetryInterval(), sessionRequestOptions.getSessionRequestTimeout(), secret);
        handler.addHandler(queue);
        LocalDistributor distributor = new LocalDistributor(tracer, bus, clientFactory, sessions, queue, distributorOptions.getSlotSelector(), secret, distributorOptions.getHealthCheckInterval(), distributorOptions.shouldRejectUnsupportedCaps());
        handler.addHandler(distributor);
        Router router = new Router(tracer, clientFactory, sessions, queue, distributor);
        GraphqlHandler graphqlHandler = new GraphqlHandler(tracer, distributor, queue, serverOptions.getExternalUri(), this.getServerVersion());
        HttpHandler readinessCheck = req -> {
            boolean ready = router.isReady() && bus.isReady();
            return (HttpResponse)new HttpResponse().setStatus(ready ? 200 : 500).setContent(Contents.utf8String((CharSequence)("Router is " + ready)));
        };
        GridUiRoute ui = new GridUiRoute();
        Routable routerWithSpecChecks = router.with(networkOptions.getSpecComplianceChecks());
        Route httpHandler = Route.combine((Routable)ui, (Routable[])new Routable[]{routerWithSpecChecks, Route.prefix((String)"/wd/hub").to(Route.combine((Routable)routerWithSpecChecks, (Routable[])new Routable[0])), Route.options((String)"/graphql").to(() -> graphqlHandler), Route.post((String)"/graphql").to(() -> graphqlHandler), Route.get((String)"/readyz").to(() -> readinessCheck)});
        return new TemplateGridServerCommand.Handlers((HttpHandler)httpHandler, new ProxyCdpIntoGrid(clientFactory, sessions));
    }

    @Override
    protected void execute(Config config) {
        Require.nonNull((String)"Config", (Object)config);
        Server server = (Server)this.asServer(config).start();
        LOG.info(String.format("Started Selenium Hub %s: %s", this.getServerVersion(), server.getUrl()));
    }

    private String getServerVersion() {
        BuildInfo info = new BuildInfo();
        return String.format("%s (revision %s)", info.getReleaseLabel(), info.getBuildRevision());
    }
}

