module org.seleniumhq.selenium.grid {
    requires failsafe;
    requires io.netty.buffer;
    requires io.netty.codec;
    requires io.netty.codec.http;
    requires io.netty.common;
    requires io.netty.handler;
    requires org.seleniumhq.selenium.devtools;
    requires org.seleniumhq.selenium.support;
    /* transitive */ requires com.google.common;
    /* transitive */ requires com.graphqljava;
    /* transitive */ requires io.netty.transport;
    /* transitive */ requires java.logging;
    /* transitive */ requires java.management;
    /* transitive */ requires javax.servlet.api;
    /* transitive */ requires jcommander;
    /* transitive */ requires jeromq;
    /* transitive */ requires org.seleniumhq.selenium.api;
    /* transitive */ requires org.seleniumhq.selenium.http;
    /* transitive */ requires org.seleniumhq.selenium.json;
    /* transitive */ requires org.seleniumhq.selenium.remote_driver;

    exports org.openqa.selenium.cli;
    exports org.openqa.selenium.concurrent;
    exports org.openqa.selenium.docker;
    exports org.openqa.selenium.docker.internal;
    exports org.openqa.selenium.docker.v1_41;
    exports org.openqa.selenium.events;
    exports org.openqa.selenium.events.local;
    exports org.openqa.selenium.events.zeromq;
    exports org.openqa.selenium.grid;
    exports org.openqa.selenium.grid.commands;
    exports org.openqa.selenium.grid.component;
    exports org.openqa.selenium.grid.data;
    exports org.openqa.selenium.grid.distributor;
    exports org.openqa.selenium.grid.distributor.config;
    exports org.openqa.selenium.grid.distributor.httpd;
    exports org.openqa.selenium.grid.distributor.local;
    exports org.openqa.selenium.grid.distributor.remote;
    exports org.openqa.selenium.grid.distributor.selector;
    exports org.openqa.selenium.grid.docker;
    exports org.openqa.selenium.grid.graphql;
    exports org.openqa.selenium.grid.jmx;
    exports org.openqa.selenium.grid.log;
    exports org.openqa.selenium.grid.node;
    exports org.openqa.selenium.grid.node.config;
    exports org.openqa.selenium.grid.node.httpd;
    exports org.openqa.selenium.grid.node.local;
    exports org.openqa.selenium.grid.node.locators;
    exports org.openqa.selenium.grid.node.remote;
    exports org.openqa.selenium.grid.router;
    exports org.openqa.selenium.grid.router.httpd;
    exports org.openqa.selenium.grid.security;
    exports org.openqa.selenium.grid.server;
    exports org.openqa.selenium.grid.sessionmap;
    exports org.openqa.selenium.grid.sessionmap.config;
    exports org.openqa.selenium.grid.sessionmap.httpd;
    exports org.openqa.selenium.grid.sessionmap.local;
    exports org.openqa.selenium.grid.sessionmap.remote;
    exports org.openqa.selenium.grid.sessionqueue;
    exports org.openqa.selenium.grid.sessionqueue.config;
    exports org.openqa.selenium.grid.sessionqueue.httpd;
    exports org.openqa.selenium.grid.sessionqueue.local;
    exports org.openqa.selenium.grid.sessionqueue.remote;
    exports org.openqa.selenium.grid.web;
    exports org.openqa.selenium.netty.server;
    exports org.openqa.selenium.status;

    opens org.openqa.selenium.grid to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.data to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.security to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.server to org.openqa.selenium.json;
    opens org.openqa.selenium.events to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.node.locators to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.commands to org.openqa.selenium.json;
    opens org.openqa.selenium.events.local to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.node.httpd to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.web to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.jmx to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.distributor.config to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.distributor to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.docker to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.node.config to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.router to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.sessionmap.local to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.router.httpd to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.sessionqueue.httpd to org.openqa.selenium.json;
    opens org.openqa.selenium.docker to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.distributor.httpd to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.distributor.local to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.sessionmap to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.sessionqueue.local to org.openqa.selenium.json;
    opens org.openqa.selenium.concurrent to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.log to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.sessionmap.httpd to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.sessionmap.config to org.openqa.selenium.json;
    opens org.openqa.selenium.docker.v1_41 to org.openqa.selenium.json;
    opens org.openqa.selenium.docker.internal to org.openqa.selenium.json;
    opens org.openqa.selenium.status to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.sessionqueue.remote to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.distributor.remote to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.distributor.selector to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.graphql to org.openqa.selenium.json;
    opens org.openqa.selenium.cli to org.openqa.selenium.json;
    opens org.openqa.selenium.netty.server to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.sessionqueue to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.node.local to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.node.remote to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.sessionqueue.config to org.openqa.selenium.json;
    opens org.openqa.selenium.events.zeromq to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.node to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.sessionmap.remote to org.openqa.selenium.json;
    opens org.openqa.selenium.grid.component to org.openqa.selenium.json;

    provides CliCommand with CompletionCommand, EventBusCommand, Hub, InfoCommand, Standalone, DistributorServer, NodeServer, RouterServer, SessionMapServer, NewSessionQueueServer;
    provides HasRoles with DistributorFlags, DockerFlags, LoggingFlags, NodeFlags, RouterFlags, BaseServerFlags, EventBusFlags, SessionMapFlags, NewSessionQueueFlags, SessionRequestFlags;
    provides CustomLocator with ById, ByName;

}

